[misk-core](../../index.md) / [misk.concurrent](../index.md) / [ExecutorServiceFactory](./index.md)

# ExecutorServiceFactory

`interface ExecutorServiceFactory`

Inject this rather than using the [Executors](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/Executors.html) factory class to create thread pools. Executors
created with this factory will automatically be shut down when the service or test completes.

For all functions, `nameFormat` a string in the format specified by
[ThreadFactoryBuilder.setNameFormat](#), like "rpc-pool-%d". If the string has a single `%d`
placeholder it will be assigned sequentially. Omit the placeholder if only one thread will be
required.

### Functions

| Name | Summary |
|---|---|
| [fixed](fixed.md) | `abstract fun fixed(nameFormat: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, threadCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`ExecutorService`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/ExecutorService.html)<br>Returns an executor service that uses [Executors.newFixedThreadPool](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/Executors.html#newFixedThreadPool(int)). |
| [scheduled](scheduled.md) | `abstract fun scheduled(nameFormat: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, threadCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`ScheduledExecutorService`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/ScheduledExecutorService.html)<br>Returns an executor service that uses [Executors.newScheduledThreadPool](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/Executors.html#newScheduledThreadPool(int)). |
| [single](single.md) | `abstract fun single(nameFormat: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`ExecutorService`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/ExecutorService.html)<br>Returns an executor service that uses [Executors.newSingleThreadExecutor](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/Executors.html#newSingleThreadExecutor()). |
| [unbounded](unbounded.md) | `abstract fun unbounded(nameFormat: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`ExecutorService`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/ExecutorService.html)<br>Returns an executor service that uses [Executors.newCachedThreadPool](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/Executors.html#newCachedThreadPool()). |
