[misk-core](../../index.md) / [misk.resources](../index.md) / [ResourceLoader](./index.md)

# ResourceLoader

`@Singleton class ResourceLoader`

ResourceLoader is a testable API for loading resources from the classpath, from the filesystem,
from memory, or from another [Backend](-backend/index.md) source.

Resource addresses have a scheme name, a colon, and an absolute filesystem-like path:
`classpath:/migrations/v1.sql`. Schemes identify backends `classpath:` or `memory:`. Paths start
with a slash and have any number of segments.

**Classpath resources** use the scheme `classpath:`. The backend reads data from the
`src/main/resources` of the project's modules and the contents of all library `.jar` files.
Classpath resources are read-only.

**Filesystem resources** use the scheme `filesystem:`. The backend reads data from the host
machine's local filesystem. It is read-only and does not support [list](list.md).

**Memory resources** use the scheme `memory:`. The backend starts empty and is populated by calls
to [put](put.md).

Other backends are permitted. They should be registered with a `MapBinder` with the backend
scheme like `classpath:` as the key.

### Types

| Name | Summary |
|---|---|
| [Backend](-backend/index.md) | `abstract class Backend` |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `ResourceLoader(backends: `[`Map`](https://docs.oracle.com/javase/8/docs/api/java/util/Map.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`ResourceLoader.Backend`](-backend/index.md)`>)`<br>ResourceLoader is a testable API for loading resources from the classpath, from the filesystem, from memory, or from another [Backend](-backend/index.md) source. |

### Functions

| Name | Summary |
|---|---|
| [copyTo](copy-to.md) | `fun copyTo(root: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, dir: `[`Path`](https://docs.oracle.com/javase/8/docs/api/java/nio/file/Path.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Copies all resources with [root](copy-to.md#misk.resources.ResourceLoader$copyTo(kotlin.String, java.nio.file.Path)/root) as a prefix to the directory [dir](copy-to.md#misk.resources.ResourceLoader$copyTo(kotlin.String, java.nio.file.Path)/dir). |
| [exists](exists.md) | `fun exists(address: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if a resource at `address` exists. |
| [list](list.md) | `fun list(address: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>`<br>Returns the full path of the resources that are immediate children of `address`. |
| [open](open.md) | `fun open(address: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): BufferedSource?`<br>Return a buffered source for `address`, or null if no such resource exists. |
| [put](put.md) | `fun put(address: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, utf8: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Writes a resource as UTF-8. Throws if the backend is readonly.`fun put(address: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, data: ByteString): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Writes a resource. Throws if the backend is readonly. |
| [requireUtf8](require-utf8.md) | `fun requireUtf8(address: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Like [utf8](utf8.md), but throws [IllegalStateException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-illegal-state-exception/index.html) if the resource is missing. |
| [utf8](utf8.md) | `fun utf8(address: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?`<br>Return the contents of `address` as a string, or null if no such resource exists. Note that this method decodes the resource on every use. It is the caller's responsibility to cache the result if it is to be loaded frequently. |
| [walk](walk.md) | `fun walk(address: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>` |

### Companion Object Properties

| Name | Summary |
|---|---|
| [SYSTEM](-s-y-s-t-e-m.md) | `val SYSTEM: `[`ResourceLoader`](./index.md) |
