[misk-core](../../index.md) / [misk.security.ssl](../index.md) / [PemComboFile](./index.md)

# PemComboFile

`data class PemComboFile`

A file containing a mix of PEM-encoded certificates and PEM-encoded private
keys. Can be used both for trust stores (which certificate authorities a TLS
client trusts) and also for TLS servers (which certificate chain a TLS server
serves).

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `PemComboFile(certificates: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<ByteString>, privateRsaKeys: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<ByteString>, privateKeys: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<ByteString>, passphrase: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`)`<br>A file containing a mix of PEM-encoded certificates and PEM-encoded private keys. Can be used both for trust stores (which certificate authorities a TLS client trusts) and also for TLS servers (which certificate chain a TLS server serves). |

### Properties

| Name | Summary |
|---|---|
| [certificates](certificates.md) | `val certificates: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<ByteString>` |
| [passphrase](passphrase.md) | `val passphrase: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [privateKeys](private-keys.md) | `val privateKeys: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<ByteString>` |
| [privateRsaKeys](private-rsa-keys.md) | `val privateRsaKeys: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<ByteString>` |

### Functions

| Name | Summary |
|---|---|
| [decodeCertificates](decode-certificates.md) | `fun decodeCertificates(): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Certificate`](https://docs.oracle.com/javase/8/docs/api/java/security/cert/Certificate.html)`>` |
| [newEmptyKeyStore](new-empty-key-store.md) | `fun newEmptyKeyStore(): `[`KeyStore`](https://docs.oracle.com/javase/8/docs/api/java/security/KeyStore.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [convertPKCS1toPKCS8](convert-p-k-c-s1to-p-k-c-s8.md) | `fun convertPKCS1toPKCS8(pkcs1Key: ByteString): `[`KeySpec`](https://docs.oracle.com/javase/8/docs/api/java/security/spec/KeySpec.html) |
| [parse](parse.md) | `fun parse(certKeyComboSource: BufferedSource, passphrase: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = null): `[`PemComboFile`](./index.md) |
