[misk-crypto](../index.md) / [misk.crypto](index.md) / [AeadKeyManager](./-aead-key-manager.md)

# AeadKeyManager

`@Singleton class AeadKeyManager : `[`MappedKeyManager`](-mapped-key-manager/index.md)`<Aead>`

Holds a map of every [Aead](#) key name to its primitive listed in the configuration for this app.
Users may use this object to obtain an [Aead](#) dynamically:

```
val myKey: Aead = aeadKeyManager["myKey"]
```

Note, that Aead instances provided by this module are envelope Aead instances. This means that
all data is encrypted with an ephemeral data encryption key (DEK), which is then protected by a key-encryption
key (KEK) and stored inline with ciphertext. This effectively means that ciphertext will be a bit larger than
the plaintext, and that migrating keys (KEKs) should not require the re-encryption of stored data.

### Inherited Functions

| Name | Summary |
|---|---|
| [get](-mapped-key-manager/get.md) | `operator fun get(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`KeyT`](-mapped-key-manager/index.md#KeyT) |
| [getNamedInstance](-mapped-key-manager/get-named-instance.md) | `fun <T> getNamedInstance(klass: `[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`T`](-mapped-key-manager/get-named-instance.md#T)`>, name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`T`](-mapped-key-manager/get-named-instance.md#T) |
