[misk-crypto](../index.md) / [misk.crypto](index.md) / [DeterministicAeadKeyManager](./-deterministic-aead-key-manager.md)

# DeterministicAeadKeyManager

`@Singleton class DeterministicAeadKeyManager : `[`MappedKeyManager`](-mapped-key-manager/index.md)`<DeterministicAead>`

Holds a map of every [DeterministicAead](#) key name to its primitive listed in the configuration for this app.
Users may use this object to obtain an [DeterministicAead](#) dynamically:

```
val myKey: DeterministicAead = deterministicAeadKeyManager["myKey"]
```

Note, that DeterministicAead objects do not provide secrecy to the same level as AEAD do, since
multiple plaintexts encrypted with the same key will produce identical ciphertext. This behavior
is desirable when querying data via its ciphertext (i.e. equality will hold), but an attacker can
detect repeated plaintexts.

### Inherited Functions

| Name | Summary |
|---|---|
| [get](-mapped-key-manager/get.md) | `operator fun get(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`KeyT`](-mapped-key-manager/index.md#KeyT) |
| [getNamedInstance](-mapped-key-manager/get-named-instance.md) | `fun <T> getNamedInstance(klass: `[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`T`](-mapped-key-manager/get-named-instance.md#T)`>, name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`T`](-mapped-key-manager/get-named-instance.md#T) |
