[misk-crypto](../../index.md) / [misk.crypto](../index.md) / [DigitalSignatureKeyManager](./index.md)

# DigitalSignatureKeyManager

`@Singleton class DigitalSignatureKeyManager : `[`MappedKeyManager`](../-mapped-key-manager/index.md)`<`[`DigitalSignature`](../-digital-signature/index.md)`>`

Holds a map of every key name to its corresponding [PublicKeySign](#) and [PublicKeyVerify](#) primitives.
Users may use this class to obtain a [PublicKeySign](#) to sign data
or [PublicKeyVerify](#) to verify the integrity of a message dynamically:

```
val signer: PublicKeySign = keyManager.getSigner("myDigitalSignatureKey")
val verifier: PublicKeyVerify = keyManager.getVerifier("mySigitalSignatureKey")
val signature = signer.sign(data)
verifier.verify(signature, data)
```

### Functions

| Name | Summary |
|---|---|
| [getSigner](get-signer.md) | `fun getSigner(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): PublicKeySign` |
| [getVerifier](get-verifier.md) | `fun getVerifier(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): PublicKeyVerify` |

### Inherited Functions

| Name | Summary |
|---|---|
| [get](../-mapped-key-manager/get.md) | `operator fun get(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`KeyT`](../-mapped-key-manager/index.md#KeyT) |
| [getNamedInstance](../-mapped-key-manager/get-named-instance.md) | `fun <T> getNamedInstance(klass: `[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`T`](../-mapped-key-manager/get-named-instance.md#T)`>, name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`T`](../-mapped-key-manager/get-named-instance.md#T) |
