[misk-crypto](../../index.md) / [misk.crypto](../index.md) / [MappedKeyManager](./index.md)

# MappedKeyManager

`sealed class MappedKeyManager<KeyT>`

### Functions

| Name | Summary |
|---|---|
| [get](get.md) | `operator fun get(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`KeyT`](index.md#KeyT) |
| [getNamedInstance](get-named-instance.md) | `fun <T> getNamedInstance(klass: `[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`T`](get-named-instance.md#T)`>, name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`T`](get-named-instance.md#T) |

### Inheritors

| Name | Summary |
|---|---|
| [AeadKeyManager](../-aead-key-manager.md) | `class AeadKeyManager : `[`MappedKeyManager`](./index.md)`<Aead>`<br>Holds a map of every [Aead](#) key name to its primitive listed in the configuration for this app. Users may use this object to obtain an [Aead](#) dynamically: |
| [DeterministicAeadKeyManager](../-deterministic-aead-key-manager.md) | `class DeterministicAeadKeyManager : `[`MappedKeyManager`](./index.md)`<DeterministicAead>`<br>Holds a map of every [DeterministicAead](#) key name to its primitive listed in the configuration for this app. Users may use this object to obtain an [DeterministicAead](#) dynamically: |
| [DigitalSignatureKeyManager](../-digital-signature-key-manager/index.md) | `class DigitalSignatureKeyManager : `[`MappedKeyManager`](./index.md)`<`[`DigitalSignature`](../-digital-signature/index.md)`>`<br>Holds a map of every key name to its corresponding [PublicKeySign](#) and [PublicKeyVerify](#) primitives. Users may use this class to obtain a [PublicKeySign](#) to sign data or [PublicKeyVerify](#) to verify the integrity of a message dynamically: |
| [MacKeyManager](../-mac-key-manager.md) | `class MacKeyManager : `[`MappedKeyManager`](./index.md)`<Mac>`<br>Holds a map of every [Mac](#) key name to its primitive listed in the configuration for this app. Users may use this class to obtain a [Mac](#) object dynamically: |
