[misk-crypto](../index.md) / [misk.crypto](./index.md)

## Package misk.crypto

### Types

| Name | Summary |
|---|---|
| [AeadKeyManager](-aead-key-manager.md) | `class AeadKeyManager : `[`MappedKeyManager`](-mapped-key-manager/index.md)`<Aead>`<br>Holds a map of every [Aead](#) key name to its primitive listed in the configuration for this app. Users may use this object to obtain an [Aead](#) dynamically: |
| [AwsKmsClientModule](-aws-kms-client-module/index.md) | `class AwsKmsClientModule : KAbstractModule`<br>AWS specific KMS client module. Currently uses a file path to a JSON credentials file to initialize the client. If no file is provided, tries to initialize the client using the default credentials path as specified in [AwsKmsClient.withDefaultCredentials](#) |
| [CryptoConfig](-crypto-config/index.md) | `data class CryptoConfig : Config`<br>Main configuration object representing to be used in the app. |
| [CryptoModule](-crypto-module/index.md) | `class CryptoModule : KAbstractModule`<br>Configures and registers the keys listed in the configuration file. Each key is read, decrypted, and then bound via Google Guice and added to the [KeyManager](#). |
| [CryptoTestModule](-crypto-test-module/index.md) | `class CryptoTestModule : KAbstractModule`<br>This module should be used for testing purposes only. It generates random keys for each key name specified in the configuration and uses [FakeKmsClient](#) instead of a real KMS service. |
| [DeterministicAeadKeyManager](-deterministic-aead-key-manager.md) | `class DeterministicAeadKeyManager : `[`MappedKeyManager`](-mapped-key-manager/index.md)`<DeterministicAead>`<br>Holds a map of every [DeterministicAead](#) key name to its primitive listed in the configuration for this app. Users may use this object to obtain an [DeterministicAead](#) dynamically: |
| [DigitalSignature](-digital-signature/index.md) | `data class DigitalSignature` |
| [DigitalSignatureKeyManager](-digital-signature-key-manager/index.md) | `class DigitalSignatureKeyManager : `[`MappedKeyManager`](-mapped-key-manager/index.md)`<`[`DigitalSignature`](-digital-signature/index.md)`>`<br>Holds a map of every key name to its corresponding [PublicKeySign](#) and [PublicKeyVerify](#) primitives. Users may use this class to obtain a [PublicKeySign](#) to sign data or [PublicKeyVerify](#) to verify the integrity of a message dynamically: |
| [GcpKmsClientModule](-gcp-kms-client-module/index.md) | `class GcpKmsClientModule : KAbstractModule`<br>GCP specific KMS client module. Uses a file path to a JSON credentials file to initialize the client. |
| [Key](-key/index.md) | `data class Key : Config`<br>Describes a specific key |
| [KeyReader](-key-reader/index.md) | `open class KeyReader` |
| [KeyType](-key-type/index.md) | `enum class KeyType`<br>Supported key types |
| [MacKeyManager](-mac-key-manager.md) | `class MacKeyManager : `[`MappedKeyManager`](-mapped-key-manager/index.md)`<Mac>`<br>Holds a map of every [Mac](#) key name to its primitive listed in the configuration for this app. Users may use this class to obtain a [Mac](#) object dynamically: |
| [MappedKeyManager](-mapped-key-manager/index.md) | `sealed class MappedKeyManager<KeyT>` |

### Exceptions

| Name | Summary |
|---|---|
| [KeyNotFoundException](-key-not-found-exception/index.md) | `class KeyNotFoundException : `[`GeneralSecurityException`](https://docs.oracle.com/javase/8/docs/api/java/security/GeneralSecurityException.html) |

### Extensions for External Classes

| Name | Summary |
|---|---|
| [com.google.crypto.tink.Aead](com.google.crypto.tink.-aead/index.md) |  |
| [com.google.crypto.tink.DeterministicAead](com.google.crypto.tink.-deterministic-aead/index.md) |  |
| [com.google.crypto.tink.Mac](com.google.crypto.tink.-mac/index.md) |  |
