[misk-events-core](../../index.md) / [misk.events](../index.md) / [Event](./index.md)

# Event

`data class Event`

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `Event(type: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, body: ByteString, occurredAt: `[`Instant`](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html)`, id: ByteString, updateVersion: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`? = null, entityIdentifier: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", partitionKey: ByteString = if (entityIdentifier.isBlank()) id else entityIdentifier.encodeUtf8(), headers: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, ByteString> = mapOf())` |

### Properties

| Name | Summary |
|---|---|
| [body](body.md) | `val body: ByteString`<br>the content so the event, encoded as a protobuf |
| [entityIdentifier](entity-identifier.md) | `val entityIdentifier: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>The id of the entity to which the event is referencing. Many but not all events are correlated with a specific entity; if this event is related to an entity, the entity_identifier should specify the id of that entity |
| [headers](headers.md) | `val headers: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, ByteString>`<br>Additional context information about the event, added and examined by infrastructure elements |
| [id](id.md) | `val id: ByteString`<br>a global unique id for the event |
| [occurredAt](occurred-at.md) | `val occurredAt: `[`Instant`](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html)<br>the instant at which the event occurred |
| [partitionKey](partition-key.md) | `val partitionKey: ByteString`<br>Partitioning key for the event. The partitioning key controls the ordering and sharding of events on a topic. Events on a topic with the same partitioning key are delivered on the same shard and in the order in which they were published.  Typically, the entity identifier is also used as a partitioning key, such that all of events on a topic for a given entity get delivered in the order in which they were submitted. However, producing applications may include an alternate partition key as part of the event to support ordering/sharding at a level above the individual entity. For example, a card processing system may want to shard and order all credit card changes relative to the customer to whom the card belongs; in this case the entity identifier is the credit card modified by the event, but the partition key is the token of the customer owning the card. |
| [type](type.md) | `val type: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>The type of event |
| [updateVersion](update-version.md) | `val updateVersion: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`?`<br>Events often represent a stream of state changes or entity updates; the update_version can be used to indicate the version of the updated entity or state machine at the time the event was generated. Legacy events may not have this field populated. New events must specify this for true ordering and race prevention. |

### Functions

| Name | Summary |
|---|---|
| [bodyAs](body-as.md) | `fun <A : Message<*, *>> bodyAs(adapter: ProtoAdapter<`[`A`](body-as.md#A)`>): `[`A`](body-as.md#A)<br>`fun <A : Message<*, *>> bodyAs(): `[`A`](body-as.md#A) |
| [header](header.md) | `fun <A : Message<*, *>> header(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, adapter: ProtoAdapter<`[`A`](header.md#A)`>): `[`A`](header.md#A)`?`<br>`fun <A : Message<*, *>> header(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`A`](header.md#A)`?` |
