[misk-events](../../index.md) / [misk.events](../index.md) / [SpooledProducer](./index.md)

# SpooledProducer

`interface SpooledProducer`

A [SpooledProducer](./index.md) is a producer that writes events to a local spool stored within a
service's database. [SpooledProducer](./index.md)s can be used to coordinate event publishing with
local database transactions. Events published to the pool are done within the application's
local database transaction; a rollback of the database transaction will also rollback
any events published to the spool. Events are asynchronously forwarded from the spool
to the event stream, and are done so through a [Producer](../-producer/index.md) transaction.

### Functions

| Name | Summary |
|---|---|
| [publish](publish.md) | `abstract fun publish(session: Session, groupRootId: Gid<*, *>, topic: Topic, vararg event: Event): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Publishes events to a sharded spool. |
| [publishUnsharded](publish-unsharded.md) | `abstract fun publishUnsharded(session: Session, topic: Topic, vararg event: Event): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Publishes events to an unsharded spool. |
