[misk-events](../index.md) / [misk.events](./index.md)

## Package misk.events

### Types

| Name | Summary |
|---|---|
| [Consumer](-consumer/index.md) | `interface Consumer`<br>A [Consumer](-consumer/index.md) allows applications to receive events from a source |
| [Producer](-producer/index.md) | `interface Producer`<br>A [Producer](-producer/index.md) is used to send events to an event stream. |
| [ProducerService](-producer-service.md) | `interface ProducerService : Service`<br>Marker interface for services that are [Producer](-producer/index.md)s. |
| [SpooledProducer](-spooled-producer/index.md) | `interface SpooledProducer`<br>A [SpooledProducer](-spooled-producer/index.md) is a producer that writes events to a local spool stored within a service's database. [SpooledProducer](-spooled-producer/index.md)s can be used to coordinate event publishing with local database transactions. Events published to the pool are done within the application's local database transaction; a rollback of the database transaction will also rollback any events published to the spool. Events are asynchronously forwarded from the spool to the event stream, and are done so through a [Producer](-producer/index.md) transaction. |

### Functions

| Name | Summary |
|---|---|
| [subscribe](subscribe.md) | `fun `[`Consumer`](-consumer/index.md)`.subscribe(topic: Topic, handler: (`[`Consumer.Context`](-consumer/-context/index.md)`, `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<Event>) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>listens for incoming events, dispatching them to a handler function |
