[misk-feature](../../index.md) / [misk.feature](../index.md) / [DynamicConfig](./index.md)

# DynamicConfig

`interface DynamicConfig`

Interface for evaluating dynamic flags. Dynamic flags are similar to feature flags, but they
don't support different variations for different keys.

### Functions

| Name | Summary |
|---|---|
| [getBoolean](get-boolean.md) | `abstract fun getBoolean(feature: `[`Feature`](../-feature/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns the value of an boolean dynamic flag. |
| [getEnum](get-enum.md) | `abstract fun <T : `[`Enum`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)`<`[`T`](get-enum.md#T)`>> getEnum(feature: `[`Feature`](../-feature/index.md)`, clazz: `[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`T`](get-enum.md#T)`>): `[`T`](get-enum.md#T)<br>Returns the value of an enumerated dynamic flag. |
| [getInt](get-int.md) | `abstract fun getInt(feature: `[`Feature`](../-feature/index.md)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Returns the value of an integer dynamic flag. |
| [getJson](get-json.md) | `abstract fun <T> getJson(feature: `[`Feature`](../-feature/index.md)`, clazz: `[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`T`](get-json.md#T)`>): `[`T`](get-json.md#T)<br>Returns the value of a JSON dynamic flag. |
| [getString](get-string.md) | `abstract fun getString(feature: `[`Feature`](../-feature/index.md)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns the value of a string dynamic flag. |

### Extension Functions

| Name | Summary |
|---|---|
| [getEnum](../get-enum.md) | `fun <T : `[`Enum`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)`<`[`T`](../get-enum.md#T)`>> `[`DynamicConfig`](./index.md)`.getEnum(feature: `[`Feature`](../-feature/index.md)`): `[`T`](../get-enum.md#T) |
| [getJson](../get-json.md) | `fun <T> `[`DynamicConfig`](./index.md)`.getJson(feature: `[`Feature`](../-feature/index.md)`): `[`T`](../get-json.md#T) |
