[misk-feature](../../index.md) / [misk.feature](../index.md) / [FeatureFlags](./index.md)

# FeatureFlags

`interface FeatureFlags`

Interface for evaluating feature flags.

### Functions

| Name | Summary |
|---|---|
| [getBoolean](get-boolean.md) | `abstract fun getBoolean(feature: `[`Feature`](../-feature/index.md)`, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, attributes: `[`Attributes`](../-attributes/index.md)` = Attributes()): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Calculates the value of an boolean feature flag for the given key and attributes.`open fun getBoolean(feature: `[`Feature`](../-feature/index.md)`, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [getEnum](get-enum.md) | `abstract fun <T : `[`Enum`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)`<`[`T`](get-enum.md#T)`>> getEnum(feature: `[`Feature`](../-feature/index.md)`, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, clazz: `[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`T`](get-enum.md#T)`>, attributes: `[`Attributes`](../-attributes/index.md)` = Attributes()): `[`T`](get-enum.md#T)<br>Calculates the value of an enumerated feature flag for the given key and attributes.`open fun <T : `[`Enum`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)`<`[`T`](get-enum.md#T)`>> getEnum(feature: `[`Feature`](../-feature/index.md)`, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, clazz: `[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`T`](get-enum.md#T)`>): `[`T`](get-enum.md#T) |
| [getInt](get-int.md) | `abstract fun getInt(feature: `[`Feature`](../-feature/index.md)`, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, attributes: `[`Attributes`](../-attributes/index.md)` = Attributes()): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Calculates the value of an integer feature flag for the given key and attributes.`open fun getInt(feature: `[`Feature`](../-feature/index.md)`, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [getJson](get-json.md) | `abstract fun <T> getJson(feature: `[`Feature`](../-feature/index.md)`, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, clazz: `[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`T`](get-json.md#T)`>, attributes: `[`Attributes`](../-attributes/index.md)` = Attributes()): `[`T`](get-json.md#T)<br>Calculates the value of a JSON feature flag for the given key and attributes.`open fun <T> getJson(feature: `[`Feature`](../-feature/index.md)`, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, clazz: `[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`T`](get-json.md#T)`>): `[`T`](get-json.md#T) |
| [getString](get-string.md) | `abstract fun getString(feature: `[`Feature`](../-feature/index.md)`, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, attributes: `[`Attributes`](../-attributes/index.md)` = Attributes()): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Calculates the value of a string feature flag for the given key and attributes.`open fun getString(feature: `[`Feature`](../-feature/index.md)`, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Extension Functions

| Name | Summary |
|---|---|
| [getEnum](../get-enum.md) | `fun <T : `[`Enum`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)`<`[`T`](../get-enum.md#T)`>> `[`FeatureFlags`](./index.md)`.getEnum(feature: `[`Feature`](../-feature/index.md)`, token: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, attributes: `[`Attributes`](../-attributes/index.md)` = Attributes()): `[`T`](../get-enum.md#T) |
| [getJson](../get-json.md) | `fun <T> `[`FeatureFlags`](./index.md)`.getJson(feature: `[`Feature`](../-feature/index.md)`, token: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, attributes: `[`Attributes`](../-attributes/index.md)` = Attributes()): `[`T`](../get-json.md#T) |
