[misk-feature](../index.md) / [misk.feature](./index.md)

## Package misk.feature

### Types

| Name | Summary |
|---|---|
| [Attributes](-attributes/index.md) | `data class Attributes`<br>Extra attributes to be used for evaluating features. |
| [DynamicConfig](-dynamic-config/index.md) | `interface DynamicConfig`<br>Interface for evaluating dynamic flags. Dynamic flags are similar to feature flags, but they don't support different variations for different keys. |
| [Feature](-feature/index.md) | `data class Feature`<br>Typed feature string. |
| [FeatureFlags](-feature-flags/index.md) | `interface FeatureFlags`<br>Interface for evaluating feature flags. |
| [FeatureFlagValidation](-feature-flag-validation/index.md) | `object FeatureFlagValidation` |
| [FeatureService](-feature-service.md) | `interface FeatureService : Service`<br>Marker interface to integrate with the misk service graph. |

### Extensions for External Classes

| Name | Summary |
|---|---|
| [com.squareup.moshi.JsonAdapter](com.squareup.moshi.-json-adapter/index.md) |  |

### Functions

| Name | Summary |
|---|---|
| [getEnum](get-enum.md) | `fun <T : `[`Enum`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)`<`[`T`](get-enum.md#T)`>> `[`DynamicConfig`](-dynamic-config/index.md)`.getEnum(feature: `[`Feature`](-feature/index.md)`): `[`T`](get-enum.md#T)<br>`fun <T : `[`Enum`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)`<`[`T`](get-enum.md#T)`>> `[`FeatureFlags`](-feature-flags/index.md)`.getEnum(feature: `[`Feature`](-feature/index.md)`, token: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, attributes: `[`Attributes`](-attributes/index.md)` = Attributes()): `[`T`](get-enum.md#T) |
| [getJson](get-json.md) | `fun <T> `[`DynamicConfig`](-dynamic-config/index.md)`.getJson(feature: `[`Feature`](-feature/index.md)`): `[`T`](get-json.md#T)<br>`fun <T> `[`FeatureFlags`](-feature-flags/index.md)`.getJson(feature: `[`Feature`](-feature/index.md)`, token: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, attributes: `[`Attributes`](-attributes/index.md)` = Attributes()): `[`T`](get-json.md#T) |
