[misk-gcp-testing](../../index.md) / [misk.cloud.gcp.storage](../index.md) / [InMemoryStorageRpc](./index.md)

# InMemoryStorageRpc

`class InMemoryStorageRpc : BaseCustomStorageRpc`

Implementation of [StorageRpc](#) that keeps all of its data purely in-memory, useful primarily
for tests. This implementation is fully thread safe.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `InMemoryStorageRpc()`<br>Implementation of [StorageRpc](#) that keeps all of its data purely in-memory, useful primarily for tests. This implementation is fully thread safe. |

### Functions

| Name | Summary |
|---|---|
| [create](create.md) | `fun create(obj: StorageObject, content: `[`InputStream`](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)`, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): StorageObject?` |
| [delete](delete.md) | `fun delete(obj: StorageObject, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [get](get.md) | `fun get(obj: StorageObject, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): StorageObject?` |
| [list](list.md) | `fun list(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): Tuple<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<StorageObject>>` |
| [load](load.md) | `fun load(obj: StorageObject, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html) |
| [open](open.md) | `fun open(obj: StorageObject, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [openRewrite](open-rewrite.md) | `fun openRewrite(request: RewriteRequest): RewriteResponse` |
| [read](read.md) | `fun read(from: StorageObject, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>, zposition: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, outputStream: `[`OutputStream`](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [write](write.md) | `fun write(uploadId: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, toWrite: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, toWriteOffset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, destOffset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, length: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, last: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
