[misk-gcp](../../index.md) / [misk.cloud.gcp.storage](../index.md) / [BaseCustomStorageRpc](./index.md)

# BaseCustomStorageRpc

`abstract class BaseCustomStorageRpc : StorageRpc`

Base for custom storage implementations. Most operations on custom storage are unsupported;
only those minimal methods requiring implementation are left abstract.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `BaseCustomStorageRpc()`<br>Base for custom storage implementations. Most operations on custom storage are unsupported; only those minimal methods requiring implementation are left abstract. |

### Functions

| Name | Summary |
|---|---|
| [compose](compose.md) | `open fun compose(sources: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<StorageObject>?, target: StorageObject?, targetOptions: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): StorageObject` |
| [continueRewrite](continue-rewrite.md) | `open fun continueRewrite(previousResponse: RewriteResponse): RewriteResponse` |
| [create](create.md) | `open fun create(bucket: Bucket, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): Bucket` |
| [createAcl](create-acl.md) | `open fun createAcl(acl: BucketAccessControl?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): BucketAccessControl`<br>`open fun createAcl(acl: ObjectAccessControl?): ObjectAccessControl` |
| [createBatch](create-batch.md) | `open fun createBatch(): RpcBatch` |
| [createDefaultAcl](create-default-acl.md) | `open fun createDefaultAcl(acl: ObjectAccessControl?): ObjectAccessControl` |
| [createNotification](create-notification.md) | `open fun createNotification(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, notification: Notification?): Notification` |
| [delete](delete.md) | `open fun delete(bucket: Bucket, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [deleteAcl](delete-acl.md) | `open fun deleteAcl(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, entity: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>`open fun deleteAcl(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, object: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, generation: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`?, entity: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [deleteDefaultAcl](delete-default-acl.md) | `open fun deleteDefaultAcl(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, entity: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [deleteNotification](delete-notification.md) | `open fun deleteNotification(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, notification: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [get](get.md) | `open fun get(bucket: Bucket, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): Bucket?` |
| [getAcl](get-acl.md) | `open fun getAcl(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, entity: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): BucketAccessControl`<br>`open fun getAcl(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, obj: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, generation: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`?, entity: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): ObjectAccessControl` |
| [getDefaultAcl](get-default-acl.md) | `open fun getDefaultAcl(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, entity: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): ObjectAccessControl` |
| [getIamPolicy](get-iam-policy.md) | `open fun getIamPolicy(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): Policy` |
| [getServiceAccount](get-service-account.md) | `open fun getServiceAccount(projectId: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): ServiceAccount` |
| [list](list.md) | `open fun list(options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): Tuple<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<Bucket>>` |
| [listAcls](list-acls.md) | `open fun listAcls(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<BucketAccessControl>`<br>`open fun listAcls(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, obj: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, generation: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`?): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<ObjectAccessControl>` |
| [listDefaultAcls](list-default-acls.md) | `open fun listDefaultAcls(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`MutableList`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)`<ObjectAccessControl>` |
| [listNotifications](list-notifications.md) | `open fun listNotifications(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<Notification>` |
| [lockRetentionPolicy](lock-retention-policy.md) | `open fun lockRetentionPolicy(bucket: Bucket?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): Bucket` |
| [open](open.md) | `open fun open(signedURL: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [patch](patch.md) | `open fun patch(bucket: Bucket, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): Bucket?`<br>`open fun patch(obj: StorageObject, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): StorageObject?` |
| [patchAcl](patch-acl.md) | `open fun patchAcl(acl: BucketAccessControl?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): BucketAccessControl`<br>`open fun patchAcl(acl: ObjectAccessControl?): ObjectAccessControl` |
| [patchDefaultAcl](patch-default-acl.md) | `open fun patchDefaultAcl(acl: ObjectAccessControl?): ObjectAccessControl` |
| [read](read.md) | `open fun read(from: StorageObject?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?, position: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, bytes: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): Tuple<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`>` |
| [setIamPolicy](set-iam-policy.md) | `open fun setIamPolicy(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, policy: Policy?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): Policy` |
| [testIamPermissions](test-iam-permissions.md) | `open fun testIamPermissions(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, permissions: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): TestIamPermissionsResponse` |

### Inheritors

| Name | Summary |
|---|---|
| [LocalStorageRpc](../-local-storage-rpc/index.md) | `class LocalStorageRpc : `[`BaseCustomStorageRpc`](./index.md)<br>Implementation of [StorageRpc](#) that is backed by local disk storage. Useful for running in development mode on local machines, since there is no GCS emulator available. Files are stored with the generation version appended as an extension suffix, with a symlink existing for the latest generation. To preserve GCS atomicity semantics, progressive uploads are handled by storing the interim uploaded data in a temporary file based off the latest generation, then doing a rename to the new generation once the upload is complete. |
