[misk-gcp](../../index.md) / [misk.cloud.gcp.storage](../index.md) / [LocalStorageRpc](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`LocalStorageRpc(root: `[`Path`](https://docs.oracle.com/javase/8/docs/api/java/nio/file/Path.html)`, moshi: Moshi = Moshi.Builder()
      .add(KotlinJsonAdapterFactory()) // Added last for lowest precedence.
      .build())`

Implementation of [StorageRpc](#) that is backed by local disk storage. Useful for running
in development mode on local machines, since there is no GCS emulator available. Files
are stored with the generation version appended as an extension suffix, with a symlink
existing for the latest generation. To preserve GCS atomicity semantics, progressive
uploads are handled by storing the interim uploaded data in a temporary file based
off the latest generation, then doing a rename to the new generation once the upload
is complete.

The implementation uses file locks to support multiple local processes accessing the same
storage directory. Whenever a blob is updated, the local store will acquire an exclusive
lock on a corresponding lock file, releasing that lock when the update is complete (or when
the process dies). It's slightly more complicated since we need to deal with the possibility
that writer stops partway through without the process failing; in those cases we don't want to
prevent subsequent updates from other processes.

Write process:

* on open
  * acquire a read lock
  * read metadata constraints, and create a new target metadata object for the next generation
  * release read lock
  * create a new temp file for receiving the update
  * generate an upload id, save the temp file location + target metadata + constraints
      in-memory associated with the upload id
* on write
  * write to the temp file for that upload id
* on finish
  * acquire a write lock, read the latest metadata for the blob and re-check constraints
      to make sure nothing changed underneath (e.g. a concurrent upload for that blob did
      not complete)
  * copy from the temp file to a new file in the content directory, appending the
      new generation number. This is done as an atomic move + overwrite
  * write updated metadata to the metadata file. This is done as an atomic move + overwrite.
      Until this is complete, the new version of the content is not accessible to readers.
  * release the write lock
  * remove the content file for the prior generation

If a writer fails between open and finish, all that happens is we have abandoned temp files
If a writer fails after moving the temp file to the contents directory but before updating
    the metadata, then we have a bad content file for that generation sitting in the content
    directory. Since the metadata hasn't been updated with the new generation, this content
    is not readable, and a subsequent write will overwrite it.
If a writer fails after updating the metadata but before removing the prior generation
    content file, we'll have left an abandoned content file. A garbage collection process
    can be run to clean these up eventually

Read process

* acquire a read lock
* read the metadata for the blob and check constraints (including etag)
* read the raw bytes from the content file
* release the read lock

Clients use etags to detect when a blob is updated while a progressive download is in place; the
etag returned from a prior read is sent in subsequent reads. We simply use the generation number
as the etag value.

