[misk-gcp](../../index.md) / [misk.cloud.gcp.storage](../index.md) / [LocalStorageRpc](./index.md)

# LocalStorageRpc

`class LocalStorageRpc : `[`BaseCustomStorageRpc`](../-base-custom-storage-rpc/index.md)

Implementation of [StorageRpc](#) that is backed by local disk storage. Useful for running
in development mode on local machines, since there is no GCS emulator available. Files
are stored with the generation version appended as an extension suffix, with a symlink
existing for the latest generation. To preserve GCS atomicity semantics, progressive
uploads are handled by storing the interim uploaded data in a temporary file based
off the latest generation, then doing a rename to the new generation once the upload
is complete.

The implementation uses file locks to support multiple local processes accessing the same
storage directory. Whenever a blob is updated, the local store will acquire an exclusive
lock on a corresponding lock file, releasing that lock when the update is complete (or when
the process dies). It's slightly more complicated since we need to deal with the possibility
that writer stops partway through without the process failing; in those cases we don't want to
prevent subsequent updates from other processes.

Write process:

* on open
  * acquire a read lock
  * read metadata constraints, and create a new target metadata object for the next generation
  * release read lock
  * create a new temp file for receiving the update
  * generate an upload id, save the temp file location + target metadata + constraints
      in-memory associated with the upload id
* on write
  * write to the temp file for that upload id
* on finish
  * acquire a write lock, read the latest metadata for the blob and re-check constraints
      to make sure nothing changed underneath (e.g. a concurrent upload for that blob did
      not complete)
  * copy from the temp file to a new file in the content directory, appending the
      new generation number. This is done as an atomic move + overwrite
  * write updated metadata to the metadata file. This is done as an atomic move + overwrite.
      Until this is complete, the new version of the content is not accessible to readers.
  * release the write lock
  * remove the content file for the prior generation

If a writer fails between open and finish, all that happens is we have abandoned temp files
If a writer fails after moving the temp file to the contents directory but before updating
    the metadata, then we have a bad content file for that generation sitting in the content
    directory. Since the metadata hasn't been updated with the new generation, this content
    is not readable, and a subsequent write will overwrite it.
If a writer fails after updating the metadata but before removing the prior generation
    content file, we'll have left an abandoned content file. A garbage collection process
    can be run to clean these up eventually

Read process

* acquire a read lock
* read the metadata for the blob and check constraints (including etag)
* read the raw bytes from the content file
* release the read lock

Clients use etags to detect when a blob is updated while a progressive download is in place; the
etag returned from a prior read is sent in subsequent reads. We simply use the generation number
as the etag value.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `LocalStorageRpc(root: `[`Path`](https://docs.oracle.com/javase/8/docs/api/java/nio/file/Path.html)`, moshi: Moshi = Moshi.Builder()
      .add(KotlinJsonAdapterFactory()) // Added last for lowest precedence.
      .build())`<br>Implementation of [StorageRpc](#) that is backed by local disk storage. Useful for running in development mode on local machines, since there is no GCS emulator available. Files are stored with the generation version appended as an extension suffix, with a symlink existing for the latest generation. To preserve GCS atomicity semantics, progressive uploads are handled by storing the interim uploaded data in a temporary file based off the latest generation, then doing a rename to the new generation once the upload is complete. |

### Functions

| Name | Summary |
|---|---|
| [create](create.md) | `fun create(obj: StorageObject, content: `[`InputStream`](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)`, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): StorageObject?` |
| [delete](delete.md) | `fun delete(obj: StorageObject, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [get](get.md) | `fun get(obj: StorageObject, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): StorageObject?` |
| [list](list.md) | `fun list(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): Tuple<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<StorageObject>>` |
| [load](load.md) | `fun load(obj: StorageObject, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html) |
| [open](open.md) | `fun open(obj: StorageObject, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [openRewrite](open-rewrite.md) | `fun openRewrite(request: RewriteRequest): RewriteResponse` |
| [read](read.md) | `fun read(from: StorageObject, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>, zposition: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, outputStream: `[`OutputStream`](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [write](write.md) | `fun write(uploadId: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, toWrite: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, toWriteOffset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, destOffset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, length: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, last: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Inherited Functions

| Name | Summary |
|---|---|
| [compose](../-base-custom-storage-rpc/compose.md) | `open fun compose(sources: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<StorageObject>?, target: StorageObject?, targetOptions: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): StorageObject` |
| [continueRewrite](../-base-custom-storage-rpc/continue-rewrite.md) | `open fun continueRewrite(previousResponse: RewriteResponse): RewriteResponse` |
| [create](../-base-custom-storage-rpc/create.md) | `open fun create(bucket: Bucket, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): Bucket` |
| [createAcl](../-base-custom-storage-rpc/create-acl.md) | `open fun createAcl(acl: BucketAccessControl?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): BucketAccessControl`<br>`open fun createAcl(acl: ObjectAccessControl?): ObjectAccessControl` |
| [createBatch](../-base-custom-storage-rpc/create-batch.md) | `open fun createBatch(): RpcBatch` |
| [createDefaultAcl](../-base-custom-storage-rpc/create-default-acl.md) | `open fun createDefaultAcl(acl: ObjectAccessControl?): ObjectAccessControl` |
| [createNotification](../-base-custom-storage-rpc/create-notification.md) | `open fun createNotification(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, notification: Notification?): Notification` |
| [delete](../-base-custom-storage-rpc/delete.md) | `open fun delete(bucket: Bucket, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [deleteAcl](../-base-custom-storage-rpc/delete-acl.md) | `open fun deleteAcl(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, entity: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>`open fun deleteAcl(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, object: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, generation: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`?, entity: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [deleteDefaultAcl](../-base-custom-storage-rpc/delete-default-acl.md) | `open fun deleteDefaultAcl(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, entity: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [deleteNotification](../-base-custom-storage-rpc/delete-notification.md) | `open fun deleteNotification(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, notification: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [get](../-base-custom-storage-rpc/get.md) | `open fun get(bucket: Bucket, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): Bucket?` |
| [getAcl](../-base-custom-storage-rpc/get-acl.md) | `open fun getAcl(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, entity: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): BucketAccessControl`<br>`open fun getAcl(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, obj: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, generation: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`?, entity: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): ObjectAccessControl` |
| [getDefaultAcl](../-base-custom-storage-rpc/get-default-acl.md) | `open fun getDefaultAcl(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, entity: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): ObjectAccessControl` |
| [getIamPolicy](../-base-custom-storage-rpc/get-iam-policy.md) | `open fun getIamPolicy(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): Policy` |
| [getServiceAccount](../-base-custom-storage-rpc/get-service-account.md) | `open fun getServiceAccount(projectId: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): ServiceAccount` |
| [list](../-base-custom-storage-rpc/list.md) | `open fun list(options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): Tuple<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<Bucket>>` |
| [listAcls](../-base-custom-storage-rpc/list-acls.md) | `open fun listAcls(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<BucketAccessControl>`<br>`open fun listAcls(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, obj: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, generation: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`?): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<ObjectAccessControl>` |
| [listDefaultAcls](../-base-custom-storage-rpc/list-default-acls.md) | `open fun listDefaultAcls(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`MutableList`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)`<ObjectAccessControl>` |
| [listNotifications](../-base-custom-storage-rpc/list-notifications.md) | `open fun listNotifications(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<Notification>` |
| [lockRetentionPolicy](../-base-custom-storage-rpc/lock-retention-policy.md) | `open fun lockRetentionPolicy(bucket: Bucket?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): Bucket` |
| [open](../-base-custom-storage-rpc/open.md) | `open fun open(signedURL: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [patch](../-base-custom-storage-rpc/patch.md) | `open fun patch(bucket: Bucket, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): Bucket?`<br>`open fun patch(obj: StorageObject, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): StorageObject?` |
| [patchAcl](../-base-custom-storage-rpc/patch-acl.md) | `open fun patchAcl(acl: BucketAccessControl?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): BucketAccessControl`<br>`open fun patchAcl(acl: ObjectAccessControl?): ObjectAccessControl` |
| [patchDefaultAcl](../-base-custom-storage-rpc/patch-default-acl.md) | `open fun patchDefaultAcl(acl: ObjectAccessControl?): ObjectAccessControl` |
| [read](../-base-custom-storage-rpc/read.md) | `open fun read(from: StorageObject?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?, position: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, bytes: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): Tuple<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`>` |
| [setIamPolicy](../-base-custom-storage-rpc/set-iam-policy.md) | `open fun setIamPolicy(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, policy: Policy?, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>?): Policy` |
| [testIamPermissions](../-base-custom-storage-rpc/test-iam-permissions.md) | `open fun testIamPermissions(bucket: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, permissions: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>, options: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Option, *>): TestIamPermissionsResponse` |
