[misk-gcp](../index.md) / [misk.cloud.gcp.storage](./index.md)

## Package misk.cloud.gcp.storage

### Types

| Name | Summary |
|---|---|
| [BaseCustomStorageRpc](-base-custom-storage-rpc/index.md) | `abstract class BaseCustomStorageRpc : StorageRpc`<br>Base for custom storage implementations. Most operations on custom storage are unsupported; only those minimal methods requiring implementation are left abstract. |
| [LocalStorageConfig](-local-storage-config/index.md) | `data class LocalStorageConfig`<br>Configuration for local (emulated) storage |
| [LocalStorageRpc](-local-storage-rpc/index.md) | `class LocalStorageRpc : `[`BaseCustomStorageRpc`](-base-custom-storage-rpc/index.md)<br>Implementation of [StorageRpc](#) that is backed by local disk storage. Useful for running in development mode on local machines, since there is no GCS emulator available. Files are stored with the generation version appended as an extension suffix, with a symlink existing for the latest generation. To preserve GCS atomicity semantics, progressive uploads are handled by storing the interim uploaded data in a temporary file based off the latest generation, then doing a rename to the new generation once the upload is complete. |
| [StorageConfig](-storage-config/index.md) | `data class StorageConfig : Config`<br>Configuration for talking to Google Cloud Storage |

### Extensions for External Classes

| Name | Summary |
|---|---|
| [com.google.api.gax.paging.Page](com.google.api.gax.paging.-page/index.md) |  |
| [com.google.cloud.ReadChannel](com.google.cloud.-read-channel/index.md) |  |
| [com.google.cloud.storage.BlobId](com.google.cloud.storage.-blob-id/index.md) |  |
| [java.nio.channels.FileChannel](java.nio.channels.-file-channel/index.md) |  |
