[misk-grpc-tests](../../../index.md) / [routeguide](../../index.md) / [RouteGuideGrpc](../index.md) / [RouteGuideStub](./index.md)

# RouteGuideStub

`class RouteGuideStub : AbstractStub<`[`RouteGuideGrpc.RouteGuideStub`](./index.md)`!>`

```

    Interface exported by the server.
    ```

### Functions

| Name | Summary |
|---|---|
| [build](build.md) | `fun build(channel: Channel!, callOptions: CallOptions!): `[`RouteGuideGrpc.RouteGuideStub`](./index.md)`!` |
| [getFeature](get-feature.md) | `fun getFeature(request: `[`RouteGuideProto.Point`](../../-route-guide-proto/-point/index.md)`!, responseObserver: StreamObserver<`[`RouteGuideProto.Feature`](../../-route-guide-proto/-feature/index.md)`!>!): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>

```

      A simple RPC.
      Obtains the feature at a given position.
      A feature with an empty name is returned if there's no feature at the given
      position.
      <br>```
<br> |
| [listFeatures](list-features.md) | `fun listFeatures(request: `[`RouteGuideProto.Rectangle`](../../-route-guide-proto/-rectangle/index.md)`!, responseObserver: StreamObserver<`[`RouteGuideProto.Feature`](../../-route-guide-proto/-feature/index.md)`!>!): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>

```

      A server-to-client streaming RPC.
      Obtains the Features available within the given Rectangle.  Results are
      streamed rather than returned at once (e.g. in a response message with a
      repeated field), as the rectangle may cover a large area and contain a
      huge number of features.
      <br>```
<br> |
| [recordRoute](record-route.md) | `fun recordRoute(responseObserver: StreamObserver<`[`RouteGuideProto.RouteSummary`](../../-route-guide-proto/-route-summary/index.md)`!>!): StreamObserver<`[`RouteGuideProto.Point`](../../-route-guide-proto/-point/index.md)`!>!`<br>

```

      A client-to-server streaming RPC.
      Accepts a stream of Points on a route being traversed, returning a
      RouteSummary when traversal is completed.
      <br>```
<br> |
| [routeChat](route-chat.md) | `fun routeChat(responseObserver: StreamObserver<`[`RouteGuideProto.RouteNote`](../../-route-guide-proto/-route-note/index.md)`!>!): StreamObserver<`[`RouteGuideProto.RouteNote`](../../-route-guide-proto/-route-note/index.md)`!>!`<br>

```

      A Bidirectional streaming RPC.
      Accepts a stream of RouteNotes sent while a route is being traversed,
      while receiving other RouteNotes (e.g. from other users).
      <br>```
<br> |
