[misk-grpc-tests](../../index.md) / [routeguide](../index.md) / [RouteGuideProto](./index.md)

# RouteGuideProto

`class RouteGuideProto`

### Types

| Name | Summary |
|---|---|
| [Feature](-feature/index.md) | `class Feature : GeneratedMessageV3, `[`RouteGuideProto.FeatureOrBuilder`](-feature-or-builder/index.md)<br>

```

    A feature names something at a given point.
    If a feature could not be named, the name is empty.
    <br>```
<br> Protobuf type `routeguide.Feature` |
| [FeatureDatabase](-feature-database/index.md) | `class FeatureDatabase : GeneratedMessageV3, `[`RouteGuideProto.FeatureDatabaseOrBuilder`](-feature-database-or-builder/index.md)<br>

```

    Not used in the RPC.  Instead, this is here for the form serialized to disk.
    <br>```
<br> Protobuf type `routeguide.FeatureDatabase` |
| [FeatureDatabaseOrBuilder](-feature-database-or-builder/index.md) | `interface FeatureDatabaseOrBuilder : MessageOrBuilder` |
| [FeatureOrBuilder](-feature-or-builder/index.md) | `interface FeatureOrBuilder : MessageOrBuilder` |
| [Point](-point/index.md) | `class Point : GeneratedMessageV3, `[`RouteGuideProto.PointOrBuilder`](-point-or-builder/index.md)<br>

```

    Points are represented as latitude-longitude pairs in the E7 representation
    (degrees multiplied by 10**7 and rounded to the nearest integer).
    Latitudes should be in the range +/- 90 degrees and longitude should be in
    the range +/- 180 degrees (inclusive).
    <br>```
<br> Protobuf type `routeguide.Point` |
| [PointOrBuilder](-point-or-builder/index.md) | `interface PointOrBuilder : MessageOrBuilder` |
| [Rectangle](-rectangle/index.md) | `class Rectangle : GeneratedMessageV3, `[`RouteGuideProto.RectangleOrBuilder`](-rectangle-or-builder/index.md)<br>

```

    A latitude-longitude rectangle, represented as two diagonally opposite
    points "lo" and "hi".
    <br>```
<br> Protobuf type `routeguide.Rectangle` |
| [RectangleOrBuilder](-rectangle-or-builder/index.md) | `interface RectangleOrBuilder : MessageOrBuilder` |
| [RouteNote](-route-note/index.md) | `class RouteNote : GeneratedMessageV3, `[`RouteGuideProto.RouteNoteOrBuilder`](-route-note-or-builder/index.md)<br>

```

    A RouteNote is a message sent while at a given point.
    <br>```
<br> Protobuf type `routeguide.RouteNote` |
| [RouteNoteOrBuilder](-route-note-or-builder/index.md) | `interface RouteNoteOrBuilder : MessageOrBuilder` |
| [RouteSummary](-route-summary/index.md) | `class RouteSummary : GeneratedMessageV3, `[`RouteGuideProto.RouteSummaryOrBuilder`](-route-summary-or-builder/index.md)<br>

```

    A RouteSummary is received in response to a RecordRoute rpc.
    It contains the number of individual points received, the number of
    detected features, and the total distance covered as the cumulative sum of
    the distance between each point.
    <br>```
<br> Protobuf type `routeguide.RouteSummary` |
| [RouteSummaryOrBuilder](-route-summary-or-builder/index.md) | `interface RouteSummaryOrBuilder : MessageOrBuilder` |

### Functions

| Name | Summary |
|---|---|
| [getDescriptor](get-descriptor.md) | `static fun getDescriptor(): FileDescriptor!` |
| [registerAllExtensions](register-all-extensions.md) | `static fun registerAllExtensions(registry: ExtensionRegistryLite!): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>`static fun registerAllExtensions(registry: ExtensionRegistry!): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
