[misk-grpc-tests](../../index.md) / [routeguide](../index.md) / [RouteSummary](./index.md)

# RouteSummary

`class RouteSummary : Message<`[`RouteSummary`](./index.md)`, `[`RouteSummary.Builder`](-builder/index.md)`>`

A RouteSummary is received in response to a RecordRoute rpc.

It contains the number of individual points received, the number of
detected features, and the total distance covered as the cumulative sum of
the distance between each point.

### Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | `class Builder : Builder<`[`RouteSummary`](./index.md)`, `[`RouteSummary.Builder`](-builder/index.md)`>` |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `RouteSummary(point_count: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`? = null, feature_count: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`? = null, distance: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`? = null, elapsed_time: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`? = null, unknownFields: ByteString = ByteString.EMPTY)`<br>A RouteSummary is received in response to a RecordRoute rpc. |

### Properties

| Name | Summary |
|---|---|
| [distance](distance.md) | `val distance: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`?`<br>The distance covered in metres. |
| [elapsed_time](elapsed_time.md) | `val elapsed_time: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`?`<br>The duration of the traversal in seconds. |
| [feature_count](feature_count.md) | `val feature_count: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`?`<br>The number of known features passed while traversing the route. |
| [point_count](point_count.md) | `val point_count: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`?`<br>The number of points received. |

### Functions

| Name | Summary |
|---|---|
| [copy](copy.md) | `fun copy(point_count: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`? = this.point_count, feature_count: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`? = this.feature_count, distance: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`? = this.distance, elapsed_time: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`? = this.elapsed_time, unknownFields: ByteString = this.unknownFields): `[`RouteSummary`](./index.md) |
| [equals](equals.md) | `fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | `fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [newBuilder](new-builder.md) | `fun newBuilder(): `[`RouteSummary.Builder`](-builder/index.md) |
| [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Companion Object Properties

| Name | Summary |
|---|---|
| [ADAPTER](-a-d-a-p-t-e-r.md) | `val ADAPTER: ProtoAdapter<`[`RouteSummary`](./index.md)`>` |
