[misk-grpc-tests](../index.md) / [routeguide](./index.md)

## Package routeguide

### Types

| Name | Summary |
|---|---|
| [Feature](-feature/index.md) | `class Feature : Message<`[`Feature`](-feature/index.md)`, `[`Feature.Builder`](-feature/-builder/index.md)`>`<br>A feature names something at a given point. |
| [FeatureDatabase](-feature-database/index.md) | `class FeatureDatabase : Message<`[`FeatureDatabase`](-feature-database/index.md)`, `[`FeatureDatabase.Builder`](-feature-database/-builder/index.md)`>`<br>Not used in the RPC.  Instead, this is here for the form serialized to disk. |
| [GrpcRouteGuideClient](-grpc-route-guide-client/index.md) | `class GrpcRouteGuideClient : `[`RouteGuideClient`](-route-guide-client/index.md)<br>Interface exported by the server. |
| [Point](-point/index.md) | `class Point : Message<`[`Point`](-point/index.md)`, `[`Point.Builder`](-point/-builder/index.md)`>`<br>Points are represented as latitude-longitude pairs in the E7 representation (degrees multiplied by 10**7 and rounded to the nearest integer). Latitudes should be in the range +/- 90 degrees and longitude should be in the range +/- 180 degrees (inclusive). |
| [Rectangle](-rectangle/index.md) | `class Rectangle : Message<`[`Rectangle`](-rectangle/index.md)`, `[`Rectangle.Builder`](-rectangle/-builder/index.md)`>`<br>A latitude-longitude rectangle, represented as two diagonally opposite points "lo" and "hi". |
| [RouteGuideClient](-route-guide-client/index.md) | `interface RouteGuideClient : Service`<br>Interface exported by the server. |
| [RouteGuideGetFeatureBlockingServer](-route-guide-get-feature-blocking-server/index.md) | `interface RouteGuideGetFeatureBlockingServer : Service`<br>Interface exported by the server. |
| [RouteGuideGrpc](-route-guide-grpc/index.md) | `class RouteGuideGrpc`<br>

```

  Interface exported by the server.
  <br>```
<br> |
| [RouteGuideListFeaturesBlockingServer](-route-guide-list-features-blocking-server/index.md) | `interface RouteGuideListFeaturesBlockingServer : Service`<br>Interface exported by the server. |
| [RouteGuideProto](-route-guide-proto/index.md) | `class RouteGuideProto` |
| [RouteGuideRecordRouteBlockingServer](-route-guide-record-route-blocking-server/index.md) | `interface RouteGuideRecordRouteBlockingServer : Service`<br>Interface exported by the server. |
| [RouteGuideRouteChatBlockingServer](-route-guide-route-chat-blocking-server/index.md) | `interface RouteGuideRouteChatBlockingServer : Service`<br>Interface exported by the server. |
| [RouteNote](-route-note/index.md) | `class RouteNote : Message<`[`RouteNote`](-route-note/index.md)`, `[`RouteNote.Builder`](-route-note/-builder/index.md)`>`<br>A RouteNote is a message sent while at a given point. |
| [RouteSummary](-route-summary/index.md) | `class RouteSummary : Message<`[`RouteSummary`](-route-summary/index.md)`, `[`RouteSummary.Builder`](-route-summary/-builder/index.md)`>`<br>A RouteSummary is received in response to a RecordRoute rpc. |
