[misk-hibernate-testing](../../index.md) / [misk.jdbc](../index.md) / [TestDatabasePool](./index.md)

# TestDatabasePool

`class TestDatabasePool : DatabasePool`

Manages an inventory of databases for testing. Databases are named like
`movies__20190730__5` where `movies` is the database name in a [DataSourceConfig](#), `20190730` is
today's date, and 5 is a sequence number.

These are used *only* in tests, so that each test gets a reserved database to avoid
parallelism issues.

Thread-safe.

### Types

| Name | Summary |
|---|---|
| [Backend](-backend/index.md) | `interface Backend`<br>A backend for a [ConfigSpecificPool](#). |
| [DatabaseName](-database-name/index.md) | `data class DatabaseName` |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `TestDatabasePool(backend: `[`TestDatabasePool.Backend`](-backend/index.md)`, clock: `[`Clock`](https://docs.oracle.com/javase/8/docs/api/java/time/Clock.html)`)`<br>Manages an inventory of databases for testing. Databases are named like `movies__20190730__5` where `movies` is the database name in a [DataSourceConfig](#), `20190730` is today's date, and 5 is a sequence number. |

### Properties

| Name | Summary |
|---|---|
| [backend](backend.md) | `val backend: `[`TestDatabasePool.Backend`](-backend/index.md) |
| [clock](clock.md) | `val clock: `[`Clock`](https://docs.oracle.com/javase/8/docs/api/java/time/Clock.html) |

### Functions

| Name | Summary |
|---|---|
| [pruneOldDatabases](prune-old-databases.md) | `fun pruneOldDatabases(retention: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)` = Duration.ofDays(2)): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Drops all databases that were created by an allocator which are older than the retention duration of this allocator. |
| [releaseDatabase](release-database.md) | `fun releaseDatabase(config: DataSourceConfig): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [takeDatabase](take-database.md) | `fun takeDatabase(config: DataSourceConfig): DataSourceConfig` |
