[misk-hibernate-testing](../../index.md) / [misk.jdbc](../index.md) / [VitessScaleSafetyChecks](./index.md)

# VitessScaleSafetyChecks

`@Singleton class VitessScaleSafetyChecks : DataSourceDecorator`

Throws a [FullScatterException](#) for scatter queries that doesn't have a lookup vindex.
Note: Current implementation is not thread safe and will not work in production.

### Types

| Name | Summary |
|---|---|
| [CowriteDetector](-cowrite-detector/index.md) | `inner class CowriteDetector : `[`ExtendedQueryExecutionListener`](../-extended-query-execution-listener/index.md) |
| [FullScatterDetector](-full-scatter-detector/index.md) | `inner class FullScatterDetector : `[`ExtendedQueryExecutionListener`](../-extended-query-execution-listener/index.md) |
| [TableScanDetector](-table-scan-detector/index.md) | `inner class TableScanDetector : `[`ExtendedQueryExecutionListener`](../-extended-query-execution-listener/index.md) |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `VitessScaleSafetyChecks(config: DataSourceConfig, okHttpClient: OkHttpClient, moshi: Moshi, transacter: Transacter, startDatabaseService: StartDatabaseService)`<br>Throws a [FullScatterException](#) for scatter queries that doesn't have a lookup vindex. Note: Current implementation is not thread safe and will not work in production. |

### Properties

| Name | Summary |
|---|---|
| [config](config.md) | `val config: DataSourceConfig` |
| [moshi](moshi.md) | `val moshi: Moshi` |
| [okHttpClient](ok-http-client.md) | `val okHttpClient: OkHttpClient` |
| [startDatabaseService](start-database-service.md) | `val startDatabaseService: StartDatabaseService` |
| [transacter](transacter.md) | `val transacter: Transacter` |

### Functions

| Name | Summary |
|---|---|
| [connect](connect.md) | `fun connect(): `[`Connection`](https://docs.oracle.com/javase/8/docs/api/java/sql/Connection.html)`?`<br>Connects directly to the Docker Vitess mysqld, bypassing vtgate entirely. We use this to dig into the query log. This is a perpetual, not connection pooled connection so should not be closed. We shut down the Vitess docker container after the tests have completed running so this doesn't need to be closed explicitly. |
| [decorate](decorate.md) | `fun decorate(dataSource: `[`DataSource`](https://docs.oracle.com/javase/8/docs/api/javax/sql/DataSource.html)`): `[`DataSource`](https://docs.oracle.com/javase/8/docs/api/javax/sql/DataSource.html) |
