[misk-hibernate](../../index.md) / [misk.database](../index.md) / [DockerVitessCluster](./index.md)

# DockerVitessCluster

`class DockerVitessCluster : `[`DatabaseServer`](../-database-server/index.md)

### Types

| Name | Summary |
|---|---|
| [LogContainerResultCallback](-log-container-result-callback/index.md) | `class LogContainerResultCallback : ResultCallbackTemplate<`[`DockerVitessCluster.LogContainerResultCallback`](-log-container-result-callback/index.md)`, Frame>` |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `DockerVitessCluster(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, moshi: Moshi, resourceLoader: ResourceLoader, config: `[`DataSourceConfig`](../../misk.jdbc/-data-source-config/index.md)`, docker: DockerClient)` |

### Properties

| Name | Summary |
|---|---|
| [cluster](cluster.md) | `val cluster: `[`VitessCluster`](../-vitess-cluster/index.md) |
| [config](config.md) | `val config: `[`DataSourceConfig`](../../misk.jdbc/-data-source-config/index.md) |
| [docker](docker.md) | `val docker: DockerClient` |
| [moshi](moshi.md) | `val moshi: Moshi` |
| [name](name.md) | `val name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [resourceLoader](resource-loader.md) | `val resourceLoader: ResourceLoader` |

### Functions

| Name | Summary |
|---|---|
| [pullImage](pull-image.md) | `fun pullImage(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [start](start.md) | `fun start(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [stop](stop.md) | `fun stop(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Properties

| Name | Summary |
|---|---|
| [CONTAINER_NAME_PREFIX](-c-o-n-t-a-i-n-e-r_-n-a-m-e_-p-r-e-f-i-x.md) | `const val CONTAINER_NAME_PREFIX: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [logger](logger.md) | `val logger: KLogger` |
| [VITESS_IMAGE](-v-i-t-e-s-s_-i-m-a-g-e.md) | `const val VITESS_IMAGE: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [VITESS_SHA](-v-i-t-e-s-s_-s-h-a.md) | `const val VITESS_SHA: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [pullImage](pull-image.md) | `fun pullImage(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [startVitessDaemon](start-vitess-daemon.md) | `fun startVitessDaemon(qualifier: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`>, config: `[`DataSourceConfig`](../../misk.jdbc/-data-source-config/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>A helper method to start the Vitess cluster outside of the dev server or test process, to enable rapid iteration. This should be called directly a `main()` function, for example: |
