[misk-hibernate](../../index.md) / [misk.hibernate.migrate](../index.md) / [BulkShardMigrator](./index.md)

# BulkShardMigrator

`class BulkShardMigrator<R : `[`DbRoot`](../../misk.hibernate/-db-root/index.md)`<`[`R`](index.md#R)`>, C : `[`DbChild`](../../misk.hibernate/-db-child/index.md)`<`[`R`](index.md#R)`, `[`C`](index.md#C)`>>`

BulkShardMigrator facilitates moving of child entities belonging to a source root entity to
target root entity in bulk. Source or target entity can either live on the same or different
shards.

If moving between shards it will copy the rows between shards using a SELECT and a batched INSERT
statements. The mutations are applied to the result set in memory between the SELECT and the
batch INSERT.

An example of moving rows from characters table that is sharded by movie_id from source_id to
target_id:

bulkShardMigratorFactory.create(transacter, sessionFactory, DbMovie::class, DbCharacter::class)
    .rootColumn("movie_id")
    .source(sourceId)
    .target(targetId)
    .execute()

### Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | `class Factory` |
| [IncMutation](-inc-mutation/index.md) | `class IncMutation : `[`BulkShardMigrator.Mutation`](-mutation/index.md) |
| [Mutation](-mutation/index.md) | `abstract class Mutation` |
| [NowMutation](-now-mutation/index.md) | `class NowMutation : `[`BulkShardMigrator.Mutation`](-mutation/index.md) |
| [SetMappingMutation](-set-mapping-mutation/index.md) | `class SetMappingMutation : `[`BulkShardMigrator.Mutation`](-mutation/index.md) |
| [SetMutation](-set-mutation/index.md) | `class SetMutation : `[`BulkShardMigrator.Mutation`](-mutation/index.md) |

### Functions

| Name | Summary |
|---|---|
| [batched](batched.md) | `fun batched(): `[`BulkShardMigrator`](./index.md)`<`[`R`](index.md#R)`, `[`C`](index.md#C)`>` |
| [batchSize](batch-size.md) | `fun batchSize(batchSize: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BulkShardMigrator`](./index.md)`<`[`R`](index.md#R)`, `[`C`](index.md#C)`>` |
| [execute](execute.md) | `fun execute(insertIgnore: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [inc](inc.md) | `operator fun inc(column: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`BulkShardMigrator`](./index.md)`<`[`R`](index.md#R)`, `[`C`](index.md#C)`>` |
| [latestBatchOnly](latest-batch-only.md) | `fun latestBatchOnly(latestBatchOnly: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`BulkShardMigrator`](./index.md)`<`[`R`](index.md#R)`, `[`C`](index.md#C)`>` |
| [now](now.md) | `fun now(column: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`BulkShardMigrator`](./index.md)`<`[`R`](index.md#R)`, `[`C`](index.md#C)`>` |
| [rootColumn](root-column.md) | `fun rootColumn(columnName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`BulkShardMigrator`](./index.md)`<`[`R`](index.md#R)`, `[`C`](index.md#C)`>` |
| [set](set.md) | `operator fun set(column: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, value: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`BulkShardMigrator`](./index.md)`<`[`R`](index.md#R)`, `[`C`](index.md#C)`>`<br>`operator fun set(column: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, valueMapper: `[`Function`](https://docs.oracle.com/javase/8/docs/api/java/util/function/Function.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>): `[`BulkShardMigrator`](./index.md)`<`[`R`](index.md#R)`, `[`C`](index.md#C)`>` |
| [source](source.md) | `fun source(sourceRoot: `[`Id`](../../misk.hibernate/-id/index.md)`<`[`R`](index.md#R)`>): `[`BulkShardMigrator`](./index.md)`<`[`R`](index.md#R)`, `[`C`](index.md#C)`>` |
| [target](target.md) | `fun target(targetRoot: `[`Id`](../../misk.hibernate/-id/index.md)`<`[`R`](index.md#R)`>): `[`BulkShardMigrator`](./index.md)`<`[`R`](index.md#R)`, `[`C`](index.md#C)`>` |
| [where](where.md) | `fun where(where: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, vararg parameters: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`BulkShardMigrator`](./index.md)`<`[`R`](index.md#R)`, `[`C`](index.md#C)`>`<br>`fun where(where: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, parameters: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<*>): `[`BulkShardMigrator`](./index.md)`<`[`R`](index.md#R)`, `[`C`](index.md#C)`>` |
