[misk-hibernate](../../index.md) / [misk.hibernate.pagination](../index.md) / [Paginator](./index.md)

# Paginator

`interface Paginator<T, in Q : `[`Query`](../../misk.hibernate/-query/index.md)`<`[`T`](index.md#T)`>>`

Breaks a query into pages. Each page break is delimited by a string that is the offset of the
last row of the preceding page.

### Functions

| Name | Summary |
|---|---|
| [applyOffset](apply-offset.md) | `abstract fun applyOffset(query: `[`Q`](index.md#Q)`, offset: `[`Offset`](../-offset/index.md)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Adjust [query](apply-offset.md#misk.hibernate.pagination.Paginator$applyOffset(misk.hibernate.pagination.Paginator.Q, misk.hibernate.pagination.Offset)/query) so that is in paging order and offset by [offset](apply-offset.md#misk.hibernate.pagination.Paginator$applyOffset(misk.hibernate.pagination.Paginator.Q, misk.hibernate.pagination.Offset)/offset) (if non-null). Most implementations will add an `ORDER BY` clause. They should also add a `WHERE column > offset` constraint if the offset is non-null. |
| [getOffset](get-offset.md) | `abstract fun getOffset(row: `[`T`](index.md#T)`): `[`Offset`](../-offset/index.md)<br>Figure out what the offset of [row](get-offset.md#misk.hibernate.pagination.Paginator$getOffset(misk.hibernate.pagination.Paginator.T)/row) is, and encode that as a string. |
