[misk-hibernate](../index.md) / [misk.hibernate.pagination](./index.md)

## Package misk.hibernate.pagination

### Types

| Name | Summary |
|---|---|
| [Offset](-offset/index.md) | `data class Offset`<br>Offset into a query. Typically this is a string-encoded ID like 5, or a composite containing a date followed by an ID, like "2019-08-16T:10:26:51Z/5". |
| [Page](-page/index.md) | `data class Page<T>` |
| [Pager](-pager/index.md) | `interface Pager<T>` |
| [Paginator](-paginator/index.md) | `interface Paginator<T, in Q : `[`Query`](../misk.hibernate/-query/index.md)`<`[`T`](-paginator/index.md#T)`>>`<br>Breaks a query into pages. Each page break is delimited by a string that is the offset of the last row of the preceding page. |

### Functions

| Name | Summary |
|---|---|
| [idAscPaginator](id-asc-paginator.md) | `fun <T : `[`DbEntity`](../misk.hibernate/-db-entity/index.md)`<`[`T`](id-asc-paginator.md#T)`>> idAscPaginator(idPath: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "id"): `[`Paginator`](-paginator/index.md)`<`[`T`](id-asc-paginator.md#T)`, `[`Query`](../misk.hibernate/-query/index.md)`<`[`T`](id-asc-paginator.md#T)`>>`<br>Pages through entities by ascending ID. |
| [idDescPaginator](id-desc-paginator.md) | `fun <T : `[`DbEntity`](../misk.hibernate/-db-entity/index.md)`<`[`T`](id-desc-paginator.md#T)`>> idDescPaginator(idPath: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "id"): `[`Paginator`](-paginator/index.md)`<`[`T`](id-desc-paginator.md#T)`, `[`Query`](../misk.hibernate/-query/index.md)`<`[`T`](id-desc-paginator.md#T)`>>`<br>Pages through entities by descending ID. |
| [listAll](list-all.md) | `fun <T : `[`DbEntity`](../misk.hibernate/-db-entity/index.md)`<`[`T`](list-all.md#T)`>, R> `[`Pager`](-pager/index.md)`<`[`T`](list-all.md#T)`>.listAll(transacter: `[`Transacter`](../misk.hibernate/-transacter/index.md)`, transform: (`[`T`](list-all.md#T)`) -> `[`R`](list-all.md#R)`): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`R`](list-all.md#R)`>` |
| [newPager](new-pager.md) | `fun <T : `[`DbEntity`](../misk.hibernate/-db-entity/index.md)`<`[`T`](new-pager.md#T)`>, Q : `[`Query`](../misk.hibernate/-query/index.md)`<`[`T`](new-pager.md#T)`>> `[`Q`](new-pager.md#Q)`.newPager(paginator: `[`Paginator`](-paginator/index.md)`<`[`T`](new-pager.md#T)`, `[`Q`](new-pager.md#Q)`>, initialOffset: `[`Offset`](-offset/index.md)`? = null, pageSize: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 100): `[`Pager`](-pager/index.md)`<`[`T`](new-pager.md#T)`>`<br>Use a null [initialOffset](new-pager.md#misk.hibernate.pagination$newPager(misk.hibernate.pagination.newPager.Q, misk.hibernate.pagination.Paginator((misk.hibernate.pagination.newPager.T, misk.hibernate.pagination.newPager.Q)), misk.hibernate.pagination.Offset, kotlin.Int)/initialOffset) to start at the beginning. |
