[misk-hibernate](../../index.md) / [misk.hibernate](../index.md) / [DbEntity](./index.md)

# DbEntity

`interface DbEntity<T : `[`DbEntity`](./index.md)`<`[`T`](index.md#T)`>>`

Marker interface for persistent entities. Ensures that only persistent entities can be passed
into [Session](../-session/index.md) methods.

You can't implement this interface directly because you need to decide on the scaling strategy:

* Use [DbSharded](../-db-sharded/index.md) subclasses [DbRoot](../-db-root/index.md) or [DbChild](../-db-child/index.md) if the entity will have unbounded growth
with usage.
* Use [DbUnsharded](../-db-unsharded.md) if your entity has bounded growth like metadata, configuration, static
data etc.

### Properties

| Name | Summary |
|---|---|
| [id](id.md) | `abstract val id: `[`Id`](../-id/index.md)`<`[`T`](index.md#T)`>` |

### Inheritors

| Name | Summary |
|---|---|
| [DbSharded](../-db-sharded/index.md) | `interface DbSharded<R : `[`DbRoot`](../-db-root/index.md)`<`[`R`](../-db-sharded/index.md#R)`>, T : `[`DbSharded`](../-db-sharded/index.md)`<`[`R`](../-db-sharded/index.md#R)`, `[`T`](../-db-sharded/index.md#T)`>> : `[`DbEntity`](./index.md)`<`[`T`](../-db-sharded/index.md#T)`>`<br>Marker interface for sharded persistent entities. Do not subclass directly, instead subclass either [DbRoot](../-db-root/index.md) for entity group roots or [DbChild](../-db-child/index.md) for entity group children. |
| [DbUnsharded](../-db-unsharded.md) | `interface DbUnsharded<T : `[`DbUnsharded`](../-db-unsharded.md)`<`[`T`](../-db-unsharded.md#T)`>> : `[`DbEntity`](./index.md)`<`[`T`](../-db-unsharded.md#T)`>`<br>Marker interface for persistent entities that have a bounded growth and do not require sharding. |
