[misk-hibernate](../../index.md) / [misk.hibernate](../index.md) / [DbSharded](./index.md)

# DbSharded

`interface DbSharded<R : `[`DbRoot`](../-db-root/index.md)`<`[`R`](index.md#R)`>, T : `[`DbSharded`](./index.md)`<`[`R`](index.md#R)`, `[`T`](index.md#T)`>> : `[`DbEntity`](../-db-entity/index.md)`<`[`T`](index.md#T)`>`

Marker interface for sharded persistent entities. Do not subclass directly, instead subclass
either [DbRoot](../-db-root/index.md) for entity group roots or [DbChild](../-db-child/index.md) for entity group children.

### Properties

| Name | Summary |
|---|---|
| [gid](gid.md) | `abstract val gid: `[`Gid`](../-gid/index.md)`<`[`R`](index.md#R)`, `[`T`](index.md#T)`>` |
| [rootId](root-id.md) | `abstract val rootId: `[`Id`](../-id/index.md)`<`[`R`](index.md#R)`>` |

### Inherited Properties

| Name | Summary |
|---|---|
| [id](../-db-entity/id.md) | `abstract val id: `[`Id`](../-id/index.md)`<`[`T`](../-db-entity/index.md#T)`>` |

### Inheritors

| Name | Summary |
|---|---|
| [DbChild](../-db-child/index.md) | `interface DbChild<R : `[`DbRoot`](../-db-root/index.md)`<`[`R`](../-db-child/index.md#R)`>, T : `[`DbChild`](../-db-child/index.md)`<`[`R`](../-db-child/index.md#R)`, `[`T`](../-db-child/index.md#T)`>> : `[`DbSharded`](./index.md)`<`[`R`](../-db-child/index.md#R)`, `[`T`](../-db-child/index.md#T)`>`<br>Marker interface for sharded entities that stay with their root inside an entity group. Entity group children will always stay inside the same shard regardless of shard splits and so on. That means transactions inside an entity group is always safe. A typical sharding strategy has a `DbCustomer` as a root and all of the entities that belong to that customer as children. |
| [DbRoot](../-db-root/index.md) | `interface DbRoot<T : `[`DbRoot`](../-db-root/index.md)`<`[`T`](../-db-root/index.md#T)`>> : `[`DbSharded`](./index.md)`<`[`T`](../-db-root/index.md#T)`, `[`T`](../-db-root/index.md#T)`>`<br>Marker interface for sharded entity group roots. Entity group roots are spread out across shards they can also have children in the form of [DbChild](../-db-child/index.md) subclasses that always stay in the same shard as their roots. A typical root is for example `DbCustomer`. |
