[misk-hibernate](../../index.md) / [misk.hibernate](../index.md) / [Query](./index.md)

# Query

`interface Query<T>`

Base class for SQL queries.

### Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | `interface Factory`<br>Creates instances of queries. |

### Properties

| Name | Summary |
|---|---|
| [firstResult](first-result.md) | `abstract var firstResult: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Set the first row to retrieve. The default is 0. |
| [maxRows](max-rows.md) | `abstract var maxRows: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>How many rows to return. Must be -1 or in range 1..10_000. |

### Functions

| Name | Summary |
|---|---|
| [count](count.md) | `abstract fun count(session: `[`Session`](../-session/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the number of rows that match the query. |
| [delete](delete.md) | `abstract fun delete(session: `[`Session`](../-session/index.md)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>the number of entities deleted |
| [disableCheck](disable-check.md) | `abstract fun disableCheck(check: `[`Check`](../-check/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [dynamicAddConstraint](dynamic-add-constraint.md) | `abstract fun dynamicAddConstraint(path: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, operator: `[`Operator`](../-operator/index.md)`, value: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`? = null): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Constrain a query using a path known only at runtime. |
| [dynamicAddOrder](dynamic-add-order.md) | `abstract fun dynamicAddOrder(path: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, asc: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [dynamicList](dynamic-list.md) | `abstract fun dynamicList(session: `[`Session`](../-session/index.md)`, selection: (CriteriaBuilder, Root<`[`T`](index.md#T)`>) -> Selection<out `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?>>`<br>Manual projections are returned as a list of rows containing a list of cells.`abstract fun dynamicList(session: `[`Session`](../-session/index.md)`, projectedPaths: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?>>` |
| [dynamicUniqueResult](dynamic-unique-result.md) | `abstract fun dynamicUniqueResult(session: `[`Session`](../-session/index.md)`, selection: (CriteriaBuilder, Root<`[`T`](index.md#T)`>) -> Selection<out `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?>?`<br>Manual projections are returned as a list of cells. Returns null if there were no results.`abstract fun dynamicUniqueResult(session: `[`Session`](../-session/index.md)`, projectedPaths: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?>?` |
| [list](list.md) | `abstract fun list(session: `[`Session`](../-session/index.md)`): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`T`](index.md#T)`>` |
| [newOrBuilder](new-or-builder.md) | `abstract fun <T : `[`Query`](./index.md)`<*>> newOrBuilder(): `[`OrBuilder`](../-or-builder/index.md)`<`[`T`](new-or-builder.md#T)`>` |
| [uniqueResult](unique-result.md) | `abstract fun uniqueResult(session: `[`Session`](../-session/index.md)`): `[`T`](index.md#T)`?`<br>Asserts that there is either zero or one results. |

### Extension Functions

| Name | Summary |
|---|---|
| [allowFullScatter](../allow-full-scatter.md) | `fun <T, Q : `[`Query`](./index.md)`<`[`T`](../allow-full-scatter.md#T)`>> `[`Q`](../allow-full-scatter.md#Q)`.allowFullScatter(): `[`Q`](../allow-full-scatter.md#Q) |
| [allowTableScan](../allow-table-scan.md) | `fun <T, Q : `[`Query`](./index.md)`<`[`T`](../allow-table-scan.md#T)`>> `[`Q`](../allow-table-scan.md#Q)`.allowTableScan(): `[`Q`](../allow-table-scan.md#Q) |
| [newPager](../../misk.hibernate.pagination/new-pager.md) | `fun <T : `[`DbEntity`](../-db-entity/index.md)`<`[`T`](../../misk.hibernate.pagination/new-pager.md#T)`>, Q : `[`Query`](./index.md)`<`[`T`](../../misk.hibernate.pagination/new-pager.md#T)`>> `[`Q`](../../misk.hibernate.pagination/new-pager.md#Q)`.newPager(paginator: `[`Paginator`](../../misk.hibernate.pagination/-paginator/index.md)`<`[`T`](../../misk.hibernate.pagination/new-pager.md#T)`, `[`Q`](../../misk.hibernate.pagination/new-pager.md#Q)`>, initialOffset: `[`Offset`](../../misk.hibernate.pagination/-offset/index.md)`? = null, pageSize: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 100): `[`Pager`](../../misk.hibernate.pagination/-pager/index.md)`<`[`T`](../../misk.hibernate.pagination/new-pager.md#T)`>`<br>Use a null [initialOffset](../../misk.hibernate.pagination/new-pager.md#misk.hibernate.pagination$newPager(misk.hibernate.pagination.newPager.Q, misk.hibernate.pagination.Paginator((misk.hibernate.pagination.newPager.T, misk.hibernate.pagination.newPager.Q)), misk.hibernate.pagination.Offset, kotlin.Int)/initialOffset) to start at the beginning. |
| [or](../or.md) | `fun <T, Q : `[`Query`](./index.md)`<`[`T`](../or.md#T)`>> `[`Q`](../or.md#Q)`.or(lambda: `[`OrBuilder`](../-or-builder/index.md)`<`[`Q`](../or.md#Q)`>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Q`](../or.md#Q)<br>Collects options that are all OR'd together. If any are true the predicate matches. |
