[misk-hibernate](../../index.md) / [misk.hibernate](../index.md) / [SecretColumn](./index.md)

# SecretColumn

`@Target([AnnotationTarget.FIELD]) annotation class SecretColumn`

[SecretColumn](./index.md) is an annotation used to get Hibernate to encrypt a field before writing it to the database.

The [keyName](key-name.md) string is used to specify the name of the key to be used to encrypt and decrypt the value.

The [indexable](indexable.md) attribute controls whether or not this data will be able to be indexed, defaulted to true. This
uses deterministic encryption: encrypting the same plaintext will produce the same ciphertext. This is weaker than
non-deterministic encryption, but makes searching for encrypted values possible. If searching for ciphertexts is
not something your use case requires, set [indexable](indexable.md) to false for stronger security.

Install [misk.crypto.CryptoModule](#) to configure the keys the app uses.
Example:
In app-common.yaml:

```
crypto:
  keys:
    - key_name: "secretColumnKey"
```

Then, in an entity class:

```
@Column
@SecretColumn(keyName = "secretColumnKey")
var secret: String
```

A Column annotated with [SecretColumn](./index.md) has the following limitations:

* It must be declared as `VARBINARY()` in its respective MySQL table. For example:

```
CREATE TABLE my_table(
  id BIGINT NOT NULL AUTO_INCREMENT,
  secret VARBINARY(500)
```

* It cannot be annotates with any other custom column annotations like [ProtoColumn](../-proto-column/index.md) or [JsonColumn](../-json-column/index.md).

*Note*:

The resulting ciphertext that is persisted in the database may be much larger in size than
the original plaintext because it also contains some metadata. Please make sure to allocate
enough space when defining the column using `VARBINARY()`.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `SecretColumn(keyName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, indexable: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = true)`<br>[SecretColumn](./index.md) is an annotation used to get Hibernate to encrypt a field before writing it to the database. |

### Properties

| Name | Summary |
|---|---|
| [indexable](indexable.md) | `val indexable: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [keyName](key-name.md) | `val keyName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
