[misk-hibernate](../../index.md) / [misk.hibernate](../index.md) / [Session](./index.md)

# Session

`interface Session`

### Properties

| Name | Summary |
|---|---|
| [hibernateSession](hibernate-session.md) | `abstract val hibernateSession: Session` |

### Functions

| Name | Summary |
|---|---|
| [delete](delete.md) | `abstract fun <T : `[`DbEntity`](../-db-entity/index.md)`<`[`T`](delete.md#T)`>> delete(entity: `[`T`](delete.md#T)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [disableChecks](disable-checks.md) | `abstract fun <T> disableChecks(checks: `[`Collection`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-collection/index.html)`<`[`Check`](../-check/index.md)`>, body: () -> `[`T`](disable-checks.md#T)`): `[`T`](disable-checks.md#T) |
| [load](load.md) | `abstract fun <T : `[`DbEntity`](../-db-entity/index.md)`<`[`T`](load.md#T)`>> load(id: `[`Id`](../-id/index.md)`<`[`T`](load.md#T)`>, type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](load.md#T)`>): `[`T`](load.md#T) |
| [loadOrNull](load-or-null.md) | `abstract fun <T : `[`DbEntity`](../-db-entity/index.md)`<`[`T`](load-or-null.md#T)`>> loadOrNull(id: `[`Id`](../-id/index.md)`<`[`T`](load-or-null.md#T)`>, type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](load-or-null.md#T)`>): `[`T`](load-or-null.md#T)`?` |
| [loadSharded](load-sharded.md) | `abstract fun <R : `[`DbRoot`](../-db-root/index.md)`<`[`R`](load-sharded.md#R)`>, T : `[`DbSharded`](../-db-sharded/index.md)`<`[`R`](load-sharded.md#R)`, `[`T`](load-sharded.md#T)`>> loadSharded(gid: `[`Gid`](../-gid/index.md)`<`[`R`](load-sharded.md#R)`, `[`T`](load-sharded.md#T)`>, type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](load-sharded.md#T)`>): `[`T`](load-sharded.md#T) |
| [onPostCommit](on-post-commit.md) | `abstract fun onPostCommit(work: () -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Registers a hook that fires after the session transaction commits. Post-commit hooks cannot affect the disposition of the transaction; if a post-commit hook fails, the failure will be logged but not propagated to the application, as the transaction will have already committed |
| [onPreCommit](on-pre-commit.md) | `abstract fun onPreCommit(work: () -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Registers a hook that fires before the session's transaction commits. Failures in a pre-commit hook will cause the transaction to be rolled back. |
| [onSessionClose](on-session-close.md) | `abstract fun onSessionClose(work: () -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Registers a hook that fires after a session is closed. This is called regardless if a session was successfully committed or rolled back. |
| [save](save.md) | `abstract fun <T : `[`DbEntity`](../-db-entity/index.md)`<`[`T`](save.md#T)`>> save(entity: `[`T`](save.md#T)`): `[`Id`](../-id/index.md)`<`[`T`](save.md#T)`>` |
| [shards](shards.md) | `abstract fun shards(): `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`Shard`](../-shard/index.md)`>`<br>`abstract fun shards(keyspace: `[`Keyspace`](../-keyspace/index.md)`): `[`Collection`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-collection/index.html)`<`[`Shard`](../-shard/index.md)`>` |
| [target](target.md) | `abstract fun <T> target(shard: `[`Shard`](../-shard/index.md)`, function: () -> `[`T`](target.md#T)`): `[`T`](target.md#T) |
| [useConnection](use-connection.md) | `abstract fun <T> useConnection(work: (`[`Connection`](https://docs.oracle.com/javase/8/docs/api/java/sql/Connection.html)`) -> `[`T`](use-connection.md#T)`): `[`T`](use-connection.md#T) |
| [withoutChecks](without-checks.md) | `abstract fun <T> withoutChecks(vararg checks: `[`Check`](../-check/index.md)`, body: () -> `[`T`](without-checks.md#T)`): `[`T`](without-checks.md#T)<br>Disable one or more checks for the duration of the execution of [body](without-checks.md#misk.hibernate.Session$withoutChecks(kotlin.Array((misk.hibernate.Check)), kotlin.Function0((misk.hibernate.Session.withoutChecks.T)))/body). The passed in checks will entirely replace the other ignored checks at this point, they will not be merged with whatever is there currently. |

### Extension Functions

| Name | Summary |
|---|---|
| [load](../load.md) | `fun <T : `[`DbEntity`](../-db-entity/index.md)`<`[`T`](../load.md#T)`>> `[`Session`](./index.md)`.load(id: `[`Id`](../-id/index.md)`<`[`T`](../load.md#T)`>): `[`T`](../load.md#T) |
| [loadOrNull](../load-or-null.md) | `fun <T : `[`DbEntity`](../-db-entity/index.md)`<`[`T`](../load-or-null.md#T)`>> `[`Session`](./index.md)`.loadOrNull(id: `[`Id`](../-id/index.md)`<`[`T`](../load-or-null.md#T)`>): `[`T`](../load-or-null.md#T)`?` |
| [loadSharded](../load-sharded.md) | `fun <R : `[`DbRoot`](../-db-root/index.md)`<`[`R`](../load-sharded.md#R)`>, S : `[`DbSharded`](../-db-sharded/index.md)`<`[`R`](../load-sharded.md#R)`, `[`S`](../load-sharded.md#S)`>> `[`Session`](./index.md)`.loadSharded(gid: `[`Gid`](../-gid/index.md)`<`[`R`](../load-sharded.md#R)`, `[`S`](../load-sharded.md#S)`>): `[`S`](../load-sharded.md#S) |
