[misk-hibernate](../../index.md) / [misk.hibernate](../index.md) / [Transacter](./index.md)

# Transacter

`interface Transacter`

Provides explicit block-based transaction demarcation.

### Properties

| Name | Summary |
|---|---|
| [inTransaction](in-transaction.md) | `abstract val inTransaction: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if the calling thread is currently within a transaction block. |

### Functions

| Name | Summary |
|---|---|
| [allowCowrites](allow-cowrites.md) | `abstract fun allowCowrites(): `[`Transacter`](./index.md)<br>Disable cowrite checks for the duration of the session. Useful for quickly setting up test data in testing. |
| [config](config.md) | `abstract fun config(): `[`DataSourceConfig`](../../misk.jdbc/-data-source-config/index.md) |
| [isCheckEnabled](is-check-enabled.md) | `abstract fun isCheckEnabled(check: `[`Check`](../-check/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Is the scalability check currently enabled. Use [Session.withoutChecks](../-session/without-checks.md) to disable checks. |
| [noRetries](no-retries.md) | `abstract fun noRetries(): `[`Transacter`](./index.md) |
| [readOnly](read-only.md) | `abstract fun readOnly(): `[`Transacter`](./index.md)<br>Creates a new transacter that produces read only sessions. This does not mean the underlying datasource is read only, only that the session produced won't modify the database. |
| [replicaRead](replica-read.md) | `abstract fun <T> replicaRead(block: (session: `[`Session`](../-session/index.md)`) -> `[`T`](replica-read.md#T)`): `[`T`](replica-read.md#T)<br>Runs a non-transactional session against a read replica. |
| [retries](retries.md) | `abstract fun retries(maxAttempts: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 2): `[`Transacter`](./index.md) |
| [transaction](transaction.md) | `abstract fun <T> transaction(block: (session: `[`Session`](../-session/index.md)`) -> `[`T`](transaction.md#T)`): `[`T`](transaction.md#T)<br>Starts a transaction on the current thread, executes [block](transaction.md#misk.hibernate.Transacter$transaction(kotlin.Function1((misk.hibernate.Session, misk.hibernate.Transacter.transaction.T)))/block), and commits the transaction. If the block raises an exception the transaction will be rolled back instead of committed. |

### Extension Functions

| Name | Summary |
|---|---|
| [failSafeRead](../fail-safe-read.md) | `fun <T> `[`Transacter`](./index.md)`.failSafeRead(block: (session: `[`Session`](../-session/index.md)`) -> `[`T`](../fail-safe-read.md#T)`): `[`T`](../fail-safe-read.md#T)<br>Runs a read on master first then tries it on replicas on failure. This method is here only for health check purpose for standby regions.`fun <T> `[`Transacter`](./index.md)`.failSafeRead(shard: `[`Shard`](../-shard/index.md)`, block: (session: `[`Session`](../-session/index.md)`) -> `[`T`](../fail-safe-read.md#T)`): `[`T`](../fail-safe-read.md#T) |
| [shards](../shards.md) | `fun `[`Transacter`](./index.md)`.shards(): `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`Shard`](../-shard/index.md)`>`<br>`fun `[`Transacter`](./index.md)`.shards(keyspace: `[`Keyspace`](../-keyspace/index.md)`): `[`Collection`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-collection/index.html)`<`[`Shard`](../-shard/index.md)`>` |
| [transaction](../transaction.md) | `fun <T> `[`Transacter`](./index.md)`.transaction(shard: `[`Shard`](../-shard/index.md)`, block: (session: `[`Session`](../-session/index.md)`) -> `[`T`](../transaction.md#T)`): `[`T`](../transaction.md#T)<br>Commits a transaction with operations of [block](../transaction.md#misk.hibernate$transaction(misk.hibernate.Transacter, misk.hibernate.Shard, kotlin.Function1((misk.hibernate.Session, misk.hibernate.transaction.T)))/block). |
