[misk-hibernate](../../index.md) / [misk.hibernate](../index.md) / [TransformedType](./index.md)

# TransformedType

`@Target([AnnotationTarget.ANNOTATION_CLASS]) annotation class TransformedType`

[TransformedType](./index.md) is a meta-annotation for assigning arbitrary transformers to entity fields. Use it to annotate
attributes that will mark a field to be transformed.

[transformer](transformer.md) is a KClass instance of a class that implements assemble and disassemble methods. Assemble is called
    when a value is read from the table, or from cache. Disassemble is called when a value is about to be written to
    a table or cache.

[targetType](target-type.md) specifies a KClass instance of the type that the field should have when disassembled. It is used to
    determine the backing SQL type.

The methods of [Transformer](../-transformer/index.md) additionally take a field representing the annotated field and a TransformerContext,
which contains limited entity state, including the name of the table and the column, the arguments the annotation
received.

Note!: Wrapping basic numberic types may not behave as one would expect, especially when querying. This is partly due
to Hibernate's inlining of primitive values.

For example, one can define a transformer that appends a value to a string prior to storage, and removes it after
retrieval. First, define the Transformer itself

class AppendTransformer(val context: TransformerContext) {
fun assemble(owner: Any?, value: Serializable): Any =
    (value as String).removeSuffix(context.arguments[suffix](#) as String))

fun disassemble(value: Any): Serializable =
    "${value as String}${context.arguments[suffix](#) as String}"
}

Then, create the entity annotation:

**Target**
(AnnotationTarget.FIELD)

**TransformedType**

(transformer = AppendTransformer::class, targetType = String::class)
annotation class SuffixedString(val suffix: String)





Then, annotate an entity field:

**Entity**

**Table**

(name="table_name")
class DbEntity : DbUnsharded(DbEntity) {
    // ...



```
    @Column("some_column")
    @SuffixedString(suffix="_suffix")
    var suffixedString : String = ""

    // ...
```


}


### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `TransformedType(transformer: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`Transformer`](../-transformer/index.md)`>, targetType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<*>)`<br>[TransformedType](./index.md) is a meta-annotation for assigning arbitrary transformers to entity fields. Use it to annotate attributes that will mark a field to be transformed. |

### Properties

| Name | Summary |
|---|---|
| [targetType](target-type.md) | `val targetType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<*>` |
| [transformer](transformer.md) | `val transformer: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`Transformer`](../-transformer/index.md)`>` |
