[misk-hibernate](../index.md) / [misk.hibernate](./index.md)

## Package misk.hibernate

### Types

| Name | Summary |
|---|---|
| [Check](-check/index.md) | `enum class Check` |
| [DbChild](-db-child/index.md) | `interface DbChild<R : `[`DbRoot`](-db-root/index.md)`<`[`R`](-db-child/index.md#R)`>, T : `[`DbChild`](-db-child/index.md)`<`[`R`](-db-child/index.md#R)`, `[`T`](-db-child/index.md#T)`>> : `[`DbSharded`](-db-sharded/index.md)`<`[`R`](-db-child/index.md#R)`, `[`T`](-db-child/index.md#T)`>`<br>Marker interface for sharded entities that stay with their root inside an entity group. Entity group children will always stay inside the same shard regardless of shard splits and so on. That means transactions inside an entity group is always safe. A typical sharding strategy has a `DbCustomer` as a root and all of the entities that belong to that customer as children. |
| [DbEntity](-db-entity/index.md) | `interface DbEntity<T : `[`DbEntity`](-db-entity/index.md)`<`[`T`](-db-entity/index.md#T)`>>`<br>Marker interface for persistent entities. Ensures that only persistent entities can be passed into [Session](-session/index.md) methods. |
| [DbRoot](-db-root/index.md) | `interface DbRoot<T : `[`DbRoot`](-db-root/index.md)`<`[`T`](-db-root/index.md#T)`>> : `[`DbSharded`](-db-sharded/index.md)`<`[`T`](-db-root/index.md#T)`, `[`T`](-db-root/index.md#T)`>`<br>Marker interface for sharded entity group roots. Entity group roots are spread out across shards they can also have children in the form of [DbChild](-db-child/index.md) subclasses that always stay in the same shard as their roots. A typical root is for example `DbCustomer`. |
| [DbSharded](-db-sharded/index.md) | `interface DbSharded<R : `[`DbRoot`](-db-root/index.md)`<`[`R`](-db-sharded/index.md#R)`>, T : `[`DbSharded`](-db-sharded/index.md)`<`[`R`](-db-sharded/index.md#R)`, `[`T`](-db-sharded/index.md#T)`>> : `[`DbEntity`](-db-entity/index.md)`<`[`T`](-db-sharded/index.md#T)`>`<br>Marker interface for sharded persistent entities. Do not subclass directly, instead subclass either [DbRoot](-db-root/index.md) for entity group roots or [DbChild](-db-child/index.md) for entity group children. |
| [DbTimestampedEntity](-db-timestamped-entity/index.md) | `interface DbTimestampedEntity`<br>This complements [DbEntity](-db-entity/index.md) for entities that keep updated_at and created_at timestamps. |
| [DbUnsharded](-db-unsharded.md) | `interface DbUnsharded<T : `[`DbUnsharded`](-db-unsharded.md)`<`[`T`](-db-unsharded.md#T)`>> : `[`DbEntity`](-db-entity/index.md)`<`[`T`](-db-unsharded.md#T)`>`<br>Marker interface for persistent entities that have a bounded growth and do not require sharding. |
| [Destination](-destination/index.md) | `data class Destination` |
| [Gid](-gid/index.md) | `data class Gid<R : `[`DbRoot`](-db-root/index.md)`<`[`R`](-gid/index.md#R)`>, T : `[`DbSharded`](-db-sharded/index.md)`<`[`R`](-gid/index.md#R)`, `[`T`](-gid/index.md#T)`>> : `[`Serializable`](https://docs.oracle.com/javase/8/docs/api/java/io/Serializable.html)<br>Entity group id, maps to two long columns one for the root id and one for the row |
| [GidGenerator](-gid-generator/index.md) | `class GidGenerator : AbstractPostInsertGenerator, Configurable` |
| [HibernateEntityModule](-hibernate-entity-module/index.md) | `abstract class HibernateEntityModule : KAbstractModule`<br>Binds hibernate entities and event listeners intended for the [Transacter](-transacter/index.md) annotated by [qualifier](#). |
| [HibernateModule](-hibernate-module/index.md) | `class HibernateModule : KAbstractModule` |
| [Id](-id/index.md) | `data class Id<T : `[`DbEntity`](-db-entity/index.md)`<`[`T`](-id/index.md#T)`>> : `[`Serializable`](https://docs.oracle.com/javase/8/docs/api/java/io/Serializable.html)`, `[`Comparable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)`<`[`Id`](-id/index.md)`<`[`T`](-id/index.md#T)`>>`<br>Type-safe persistent identifier, mapped to a long column. |
| [IdType](-id-type/index.md) | `class IdType : UserType, ResultSetIdentifierConsumer`<br>Binds Id&lt;*&gt; in the DB to a bigint in MySQL. |
| [Keyspace](-keyspace/index.md) | `data class Keyspace` |
| [Operator](-operator/index.md) | `enum class Operator` |
| [OrBuilder](-or-builder/index.md) | `interface OrBuilder<Q : `[`Query`](-query/index.md)`<*>>`<br>This functional interface accepts a set of options. Each option lambda is executed within the scope of a query. It is inappropriate to call methods like list() and uniqueResult() on this query. |
| [Path](-path/index.md) | `data class Path` |
| [Projection](-projection.md) | `interface Projection`<br>Marker interface for query projections. |
| [Query](-query/index.md) | `interface Query<T>`<br>Base class for SQL queries. |
| [SchemaMigratorService](-schema-migrator-service/index.md) | `class SchemaMigratorService : AbstractIdleService, HealthCheck` |
| [Session](-session/index.md) | `interface Session` |
| [Shard](-shard/index.md) | `data class Shard` |
| [TabletType](-tablet-type/index.md) | `enum class TabletType` |
| [Transacter](-transacter/index.md) | `interface Transacter`<br>Provides explicit block-based transaction demarcation. |
| [TransacterService](-transacter-service.md) | `interface TransacterService : Service`<br>Marker interface for services that provide database transactors. |
| [Transformer](-transformer/index.md) | `abstract class Transformer` |
| [TransformerContext](-transformer-context/index.md) | `data class TransformerContext` |
| [ValidationReport](-validation-report/index.md) | `data class ValidationReport` |
| [VitessDialect](-vitess-dialect/index.md) | `class VitessDialect : MySQL57Dialect` |

### Annotations

| Name | Summary |
|---|---|
| [Constraint](-constraint/index.md) | `annotation class Constraint`<br>Annotates a function on a subinterface of [Query](-query/index.md) to indicate which column (or path of columns) it constrains and using which operator. |
| [JsonColumn](-json-column/index.md) | `annotation class JsonColumn`<br>Put this on a column field to get Hibernate to persist it as JSON using Moshi. It will use the injector's configured Moshi instance. Use [misk.moshi.MoshiModule](#) to customize. |
| [Order](-order/index.md) | `annotation class Order`<br>Annotates a function on a subinterface of [Query](-query/index.md) to indicate which columns to order the the selected columns. |
| [Property](-property/index.md) | `annotation class Property`<br>Annotates a parameter of a [Projection](-projection.md) data class to indicate which column (or path of columns) to populate the parameter with. |
| [ProtoColumn](-proto-column/index.md) | `annotation class ProtoColumn`<br>Put this on a column field for a class generated by Wire to get Hibernate to persist with protobuf serialization. |
| [SecretColumn](-secret-column/index.md) | `annotation class SecretColumn`<br>[SecretColumn](-secret-column/index.md) is an annotation used to get Hibernate to encrypt a field before writing it to the database. |
| [Select](-select/index.md) | `annotation class Select`<br>Annotates a function on a subinterface of [Query](-query/index.md) to execute a `SELECT` query. Functions with this annotation must return a `List` to fetch multiple rows results, or a regular type to fetch a unique result. |
| [TransformedType](-transformed-type/index.md) | `annotation class TransformedType`<br>[TransformedType](-transformed-type/index.md) is a meta-annotation for assigning arbitrary transformers to entity fields. Use it to annotate attributes that will mark a field to be transformed. |

### Exceptions

| Name | Summary |
|---|---|
| [PostCommitHookFailedException](-post-commit-hook-failed-exception/index.md) | `class PostCommitHookFailedException : `[`Exception`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-exception/index.html)<br>[PostCommitHookFailedException](-post-commit-hook-failed-exception/index.md) is raised when a code run as part of a post-commit hook fails. Because post-commit hooks are run after the transaction is committed, failure in these hooks does not cause the transaction to rollback, and applications may need to differentiate the two cases (exception occurred and caused the transaction to rollback, exception occurred during a post-commit hook |
| [RetryTransactionException](-retry-transaction-exception/index.md) | `class RetryTransactionException : `[`Exception`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-exception/index.html)<br>Thrown to explicitly trigger a retry, subject to retry limits and config such as noRetries(). |

### Extensions for External Classes

| Name | Summary |
|---|---|
| [java.sql.PreparedStatement](java.sql.-prepared-statement/index.md) |  |
| [java.sql.ResultSet](java.sql.-result-set/index.md) |  |

### Functions

| Name | Summary |
|---|---|
| [allowFullScatter](allow-full-scatter.md) | `fun <T, Q : `[`Query`](-query/index.md)`<`[`T`](allow-full-scatter.md#T)`>> `[`Q`](allow-full-scatter.md#Q)`.allowFullScatter(): `[`Q`](allow-full-scatter.md#Q) |
| [allowTableScan](allow-table-scan.md) | `fun <T, Q : `[`Query`](-query/index.md)`<`[`T`](allow-table-scan.md#T)`>> `[`Q`](allow-table-scan.md#Q)`.allowTableScan(): `[`Q`](allow-table-scan.md#Q) |
| [checkValidShardIdentifier](check-valid-shard-identifier.md) | `fun checkValidShardIdentifier(identifier: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [failSafeRead](fail-safe-read.md) | `fun <T> `[`Transacter`](-transacter/index.md)`.failSafeRead(block: (session: `[`Session`](-session/index.md)`) -> `[`T`](fail-safe-read.md#T)`): `[`T`](fail-safe-read.md#T)<br>Runs a read on master first then tries it on replicas on failure. This method is here only for health check purpose for standby regions.`fun <T> `[`Transacter`](-transacter/index.md)`.failSafeRead(shard: `[`Shard`](-shard/index.md)`, block: (session: `[`Session`](-session/index.md)`) -> `[`T`](fail-safe-read.md#T)`): `[`T`](fail-safe-read.md#T) |
| [getRooCause](get-roo-cause.md) | `fun getRooCause(throwable: `[`Throwable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)`): `[`Throwable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html) |
| [load](load.md) | `fun <T : `[`DbEntity`](-db-entity/index.md)`<`[`T`](load.md#T)`>> `[`Session`](-session/index.md)`.load(id: `[`Id`](-id/index.md)`<`[`T`](load.md#T)`>): `[`T`](load.md#T) |
| [loadOrNull](load-or-null.md) | `fun <T : `[`DbEntity`](-db-entity/index.md)`<`[`T`](load-or-null.md#T)`>> `[`Session`](-session/index.md)`.loadOrNull(id: `[`Id`](-id/index.md)`<`[`T`](load-or-null.md#T)`>): `[`T`](load-or-null.md#T)`?` |
| [loadSharded](load-sharded.md) | `fun <R : `[`DbRoot`](-db-root/index.md)`<`[`R`](load-sharded.md#R)`>, S : `[`DbSharded`](-db-sharded/index.md)`<`[`R`](load-sharded.md#R)`, `[`S`](load-sharded.md#S)`>> `[`Session`](-session/index.md)`.loadSharded(gid: `[`Gid`](-gid/index.md)`<`[`R`](load-sharded.md#R)`, `[`S`](load-sharded.md#S)`>): `[`S`](load-sharded.md#S) |
| [newQuery](new-query.md) | `fun <T : `[`Query`](-query/index.md)`<*>> `[`Query.Factory`](-query/-factory/index.md)`.newQuery(): `[`T`](new-query.md#T) |
| [or](or.md) | `fun <T, Q : `[`Query`](-query/index.md)`<`[`T`](or.md#T)`>> `[`Q`](or.md#Q)`.or(lambda: `[`OrBuilder`](-or-builder/index.md)`<`[`Q`](or.md#Q)`>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Q`](or.md#Q)<br>Collects options that are all OR'd together. If any are true the predicate matches. |
| [shards](shards.md) | `fun `[`Transacter`](-transacter/index.md)`.shards(): `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`Shard`](-shard/index.md)`>`<br>`fun `[`Transacter`](-transacter/index.md)`.shards(keyspace: `[`Keyspace`](-keyspace/index.md)`): `[`Collection`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-collection/index.html)`<`[`Shard`](-shard/index.md)`>` |
| [tabletDoesNotExists](tablet-does-not-exists.md) | `fun tabletDoesNotExists(e: `[`Exception`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-exception/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [transaction](transaction.md) | `fun <T> `[`Transacter`](-transacter/index.md)`.transaction(shard: `[`Shard`](-shard/index.md)`, block: (session: `[`Session`](-session/index.md)`) -> `[`T`](transaction.md#T)`): `[`T`](transaction.md#T)<br>Commits a transaction with operations of [block](transaction.md#misk.hibernate$transaction(misk.hibernate.Transacter, misk.hibernate.Shard, kotlin.Function1((misk.hibernate.Session, misk.hibernate.transaction.T)))/block). |
