[misk-hibernate](../index.md) / [misk.hibernate](index.md) / [transaction](./transaction.md)

# transaction

`fun <T> `[`Transacter`](-transacter/index.md)`.transaction(shard: `[`Shard`](-shard/index.md)`, block: (session: `[`Session`](-session/index.md)`) -> `[`T`](transaction.md#T)`): `[`T`](transaction.md#T)

Commits a transaction with operations of [block](transaction.md#misk.hibernate$transaction(misk.hibernate.Transacter, misk.hibernate.Shard, kotlin.Function1((misk.hibernate.Session, misk.hibernate.transaction.T)))/block).

New objects must be persisted with an explicit call to [Session.save](-session/save.md).
Updates are performed implicitly by modifying objects returned from a query.

For example if we were to save a new movie to a movie database, and update the revenue of an
existing movie:

```
transacter.transaction { session ->
  // Saving a new entity to the database needs an explicit call.
  val starWars = DbMovie(name = "Star Wars", year = "1977", revenue = 775_400_000)
  session.save(starWars)

  // Updating a movie from the database is done by modifying the object.
  // Changes are saved implicitly.
  val movie: DbMovie = queryFactory.newQuery<MovieQuery>().id(id).uniqueResult(session)!!
  movie.revenue = 100_000_000
}
```

