[misk-hibernate](../../index.md) / [misk.jdbc](../index.md) / [Cluster](./index.md)

# Cluster

`interface Cluster<T>`

[Cluster](./index.md) provides a consistent abstraction for
interacting with various database-related resources [T](index.md#T)
based on their role in the underlying database topology.

Database clusters are often composed of a Read/Write master
instance and a set of Read-Only replica instances.

Misk defers management of these replicas to the underlying
persistence layer and requires a single addressable endpoint.

Examples include a Read-Only [DataSource](#) or a Read/Write
[SessionFactory](#) in Hibernate.

N.B. If a Read-Only resource is not provided Misk will
default to the Read/Write resource.

### Properties

| Name | Summary |
|---|---|
| [reader](reader.md) | `abstract val reader: `[`T`](index.md#T) |
| [writer](writer.md) | `abstract val writer: `[`T`](index.md#T) |

### Inheritors

| Name | Summary |
|---|---|
| [DataSourceCluster](../-data-source-cluster/index.md) | `class DataSourceCluster : `[`Cluster`](./index.md)`<`[`DataSource`](https://docs.oracle.com/javase/8/docs/api/javax/sql/DataSource.html)`>` |
