[misk-hibernate](../../index.md) / [misk.jdbc](../index.md) / [DataSourceConfig](./index.md)

# DataSourceConfig

`data class DataSourceConfig`

Configuration element for an individual datasource

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `DataSourceConfig(type: `[`DataSourceType`](../-data-source-type/index.md)`, host: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = null, port: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`? = null, database: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = null, username: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = null, password: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = null, fixed_pool_size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 10, connection_timeout: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)` = Duration.ofSeconds(10), validation_timeout: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)` = Duration.ofSeconds(3), connection_max_lifetime: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)` = Duration.ofMinutes(1), query_timeout: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`? = Duration.ofMinutes(1), migrations_resource: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = null, migrations_resources: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>? = null, vitess_schema_resource_root: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = null, trust_certificate_key_store_url: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = null, trust_certificate_key_store_password: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = null, client_certificate_key_store_url: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = null, client_certificate_key_store_password: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = null, trust_certificate_key_store_path: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = null, client_certificate_key_store_path: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = null, verify_server_identity: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false, show_sql: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = "false", jdbc_statement_batch_size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`? = null)`<br>Configuration element for an individual datasource |

### Properties

| Name | Summary |
|---|---|
| [client_certificate_key_store_password](client_certificate_key_store_password.md) | `val client_certificate_key_store_password: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [client_certificate_key_store_path](client_certificate_key_store_path.md) | `val client_certificate_key_store_path: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [client_certificate_key_store_url](client_certificate_key_store_url.md) | `val client_certificate_key_store_url: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [connection_max_lifetime](connection_max_lifetime.md) | `val connection_max_lifetime: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html) |
| [connection_timeout](connection_timeout.md) | `val connection_timeout: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html) |
| [database](database.md) | `val database: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [fixed_pool_size](fixed_pool_size.md) | `val fixed_pool_size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [host](host.md) | `val host: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [jdbc_statement_batch_size](jdbc_statement_batch_size.md) | `val jdbc_statement_batch_size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`?` |
| [migrations_resource](migrations_resource.md) | `val migrations_resource: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [migrations_resources](migrations_resources.md) | `val migrations_resources: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>?` |
| [password](password.md) | `val password: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [port](port.md) | `val port: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`?` |
| [query_timeout](query_timeout.md) | `val query_timeout: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`?` |
| [show_sql](show_sql.md) | `val show_sql: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [trust_certificate_key_store_password](trust_certificate_key_store_password.md) | `val trust_certificate_key_store_password: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [trust_certificate_key_store_path](trust_certificate_key_store_path.md) | `val trust_certificate_key_store_path: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [trust_certificate_key_store_url](trust_certificate_key_store_url.md) | `val trust_certificate_key_store_url: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [type](type.md) | `val type: `[`DataSourceType`](../-data-source-type/index.md) |
| [username](username.md) | `val username: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [validation_timeout](validation_timeout.md) | `val validation_timeout: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html) |
| [verify_server_identity](verify_server_identity.md) | `val verify_server_identity: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [vitess_schema_resource_root](vitess_schema_resource_root.md) | `val vitess_schema_resource_root: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |

### Functions

| Name | Summary |
|---|---|
| [asReplica](as-replica.md) | `fun asReplica(): `[`DataSourceConfig`](./index.md) |
| [buildJdbcUrl](build-jdbc-url.md) | `fun buildJdbcUrl(env: Environment): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [withDefaults](with-defaults.md) | `fun withDefaults(): `[`DataSourceConfig`](./index.md) |
