[misk-hibernate](../../index.md) / [misk.jdbc](../index.md) / [DataSourceService](./index.md)

# DataSourceService

`@Singleton class DataSourceService : AbstractIdleService, `[`DataSourceConnector`](../-data-source-connector/index.md)`, Provider<`[`DataSource`](https://docs.oracle.com/javase/8/docs/api/javax/sql/DataSource.html)`>`

Builds a connection pool to a JDBC database. Doesn't do any schema migration or validation.

### Parameters

`baseConfig` - the configuration to connect to. The actual database name used may vary as
    the [databasePool](#) can pick an alternate database name for testing.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `DataSourceService(qualifier: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`>, baseConfig: `[`DataSourceConfig`](../-data-source-config/index.md)`, environment: Environment, dataSourceDecorators: `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`DataSourceDecorator`](../-data-source-decorator/index.md)`>, databasePool: `[`DatabasePool`](../-database-pool/index.md)`, metrics: Metrics? = null)`<br>Builds a connection pool to a JDBC database. Doesn't do any schema migration or validation. |

### Functions

| Name | Summary |
|---|---|
| [config](config.md) | `fun config(): `[`DataSourceConfig`](../-data-source-config/index.md) |
| [get](get.md) | `fun get(): `[`DataSource`](https://docs.oracle.com/javase/8/docs/api/javax/sql/DataSource.html) |
| [shutDown](shut-down.md) | `fun shutDown(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [startUp](start-up.md) | `fun startUp(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Properties

| Name | Summary |
|---|---|
| [logger](logger.md) | `val logger: KLogger` |
