[misk-hibernate](../index.md) / [misk.jdbc](./index.md)

## Package misk.jdbc

### Types

| Name | Summary |
|---|---|
| [Cluster](-cluster/index.md) | `interface Cluster<T>`<br>[Cluster](-cluster/index.md) provides a consistent abstraction for interacting with various database-related resources [T](-cluster/index.md#T) based on their role in the underlying database topology. |
| [DatabasePool](-database-pool/index.md) | `interface DatabasePool`<br>Figures out what database name to use for a given config. Tests use this to pool many databases for concurrent execution. In development, staging, and production the database never changes. |
| [DataSourceCluster](-data-source-cluster/index.md) | `class DataSourceCluster : `[`Cluster`](-cluster/index.md)`<`[`DataSource`](https://docs.oracle.com/javase/8/docs/api/javax/sql/DataSource.html)`>` |
| [DataSourceClusterConfig](-data-source-cluster-config/index.md) | `data class DataSourceClusterConfig`<br>Configuration element for a cluster of DataSources |
| [DataSourceClustersConfig](-data-source-clusters-config/index.md) | `class DataSourceClustersConfig : `[`LinkedHashMap`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-linked-hash-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`DataSourceClusterConfig`](-data-source-cluster-config/index.md)`>, Config`<br>Top-level configuration element for all datasource clusters |
| [DataSourceConfig](-data-source-config/index.md) | `data class DataSourceConfig`<br>Configuration element for an individual datasource |
| [DataSourceConnector](-data-source-connector/index.md) | `interface DataSourceConnector` |
| [DataSourceDecorator](-data-source-decorator/index.md) | `interface DataSourceDecorator` |
| [DataSourceService](-data-source-service/index.md) | `class DataSourceService : AbstractIdleService, `[`DataSourceConnector`](-data-source-connector/index.md)`, Provider<`[`DataSource`](https://docs.oracle.com/javase/8/docs/api/javax/sql/DataSource.html)`>`<br>Builds a connection pool to a JDBC database. Doesn't do any schema migration or validation. |
| [DataSourceType](-data-source-type/index.md) | `enum class DataSourceType`<br>Defines a type of datasource |
| [PingDatabaseService](-ping-database-service/index.md) | `class PingDatabaseService : AbstractIdleService`<br>Service that waits for the database to become healthy. This is needed if we're booting up a Vitess cluster as part of the test run. |
| [RealDatabasePool](-real-database-pool/index.md) | `object RealDatabasePool : `[`DatabasePool`](-database-pool/index.md) |
| [SpanInjector](-span-injector/index.md) | `class SpanInjector : QueryTransformer, `[`DataSourceDecorator`](-data-source-decorator/index.md)<ul><li></li></ul> |
| [StringBuilderCarrier](-string-builder-carrier/index.md) | `class StringBuilderCarrier : TextMap` |

### Exceptions

| Name | Summary |
|---|---|
| [CowriteException](-cowrite-exception/index.md) | `class CowriteException : PersistenceException`<br>Thrown when a transaction that writes to multiple entity groups is detected. |
| [FullScatterException](-full-scatter-exception/index.md) | `class FullScatterException : PersistenceException`<br>Exception thrown if we use a scatter query that is too wide in the wrong context. |
| [TableScanException](-table-scan-exception/index.md) | `class TableScanException : PersistenceException`<br>Exception thrown if we execute a query lacking an index. |

### Extensions for External Classes

| Name | Summary |
|---|---|
| [java.sql.ResultSet](java.sql.-result-set/index.md) |  |
