[misk-hibernate](../../index.md) / [misk.vitess](../index.md) / [VitessCluster](./index.md)

# VitessCluster

`class VitessCluster`

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `VitessCluster(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, resourceLoader: ResourceLoader, config: `[`DataSourceConfig`](../../misk.jdbc/-data-source-config/index.md)`, moshi: Moshi = Moshi.Builder()
      .add(KotlinJsonAdapterFactory()) // Added last for lowest precedence.
      .build())` |

### Properties

| Name | Summary |
|---|---|
| [config](config.md) | `val config: `[`DataSourceConfig`](../../misk.jdbc/-data-source-config/index.md) |
| [configDir](config-dir.md) | `val configDir: `[`Path`](http://docs.oracle.com/javase/8/docs/api/java/nio/file/Path.html) |
| [grpcPort](grpc-port.md) | `val grpcPort: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [httpPort](http-port.md) | `val httpPort: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [keyspaceAdapter](keyspace-adapter.md) | `val keyspaceAdapter: JsonAdapter<`[`Keyspace`](../-keyspace/index.md)`>` |
| [moshi](moshi.md) | `val moshi: Moshi` |
| [mysqlPort](mysql-port.md) | `val mysqlPort: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [name](name.md) | `val name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [schemaDir](schema-dir.md) | `val schemaDir: `[`Path`](http://docs.oracle.com/javase/8/docs/api/java/nio/file/Path.html) |
| [vtgateMysqlPort](vtgate-mysql-port.md) | `val vtgateMysqlPort: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |

### Functions

| Name | Summary |
|---|---|
| [keyspaces](keyspaces.md) | `fun keyspaces(): `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`Keyspace`](../-keyspace/index.md)`>` |
| [openMysqlConnection](open-mysql-connection.md) | `fun openMysqlConnection(): `[`Connection`](http://docs.oracle.com/javase/8/docs/api/java/sql/Connection.html)<br>Connect to the underlying MySQL database, bypassing Vitess entirely. |
| [openVtgateConnection](open-vtgate-connection.md) | `fun openVtgateConnection(): `[`Connection`](http://docs.oracle.com/javase/8/docs/api/java/sql/Connection.html)<br>Connect to vtgate. |
