[misk-inject](../../index.md) / [misk.inject](../index.md) / [KAbstractModule](./index.md)

# KAbstractModule

`abstract class KAbstractModule : AbstractModule`

A class that provides helper methods for working with Kotlin and Guice, allowing implementing
classes to operate in the Kotlin type system rather than converting to Java.

The more Kotlin friendly API allows calls like:

```
bind(Foo::class.java).to(RealFoo::class.java)
```

To be rewritten as:

```
bind<Foo>().to<RealFoo>()
```

### Types

| Name | Summary |
|---|---|
| [KotlinAnnotatedBindingBuilder](-kotlin-annotated-binding-builder/index.md) | `class KotlinAnnotatedBindingBuilder<X> : AnnotatedBindingBuilder<`[`X`](-kotlin-annotated-binding-builder/index.md#X)`>` |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `KAbstractModule()`<br>A class that provides helper methods for working with Kotlin and Guice, allowing implementing classes to operate in the Kotlin type system rather than converting to Java. |

### Functions

| Name | Summary |
|---|---|
| [bind](bind.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> bind(): `[`KAbstractModule.KotlinAnnotatedBindingBuilder`](-kotlin-annotated-binding-builder/index.md)`<in `[`T`](bind.md#T)`>` |
| [binder](binder.md) | `open fun binder(): Binder` |
| [multibind](multibind.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> multibind(annotation: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`>? = null): LinkedBindingBuilder<`[`T`](multibind.md#T)`>`<br>`fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, A : `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`> multibind(): LinkedBindingBuilder<`[`T`](multibind.md#T)`>` |
| [newMapBinder](new-map-binder.md) | `fun <K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, V : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> newMapBinder(annotation: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`>? = null): MapBinder<`[`K`](new-map-binder.md#K)`, `[`V`](new-map-binder.md#V)`>`<br>`fun <K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, V : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> newMapBinder(keyType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`K`](new-map-binder.md#K)`>, valueType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`V`](new-map-binder.md#V)`>, annotation: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`>? = null): MapBinder<`[`K`](new-map-binder.md#K)`, `[`V`](new-map-binder.md#V)`>`<br>`fun <K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, V : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> newMapBinder(keyType: TypeLiteral<`[`K`](new-map-binder.md#K)`>, valueType: TypeLiteral<`[`V`](new-map-binder.md#V)`>, annotation: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`>? = null): MapBinder<`[`K`](new-map-binder.md#K)`, `[`V`](new-map-binder.md#V)`>` |
| [newMultibinder](new-multibinder.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> newMultibinder(annotation: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`>? = null): Multibinder<`[`T`](new-multibinder.md#T)`>`<br>`fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> newMultibinder(type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](new-multibinder.md#T)`>, annotation: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`>? = null): Multibinder<`[`T`](new-multibinder.md#T)`>` |
| [requireBinding](require-binding.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> requireBinding(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [to](to.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> LinkedBindingBuilder<in `[`T`](to.md#T)`>.to(): ScopedBindingBuilder` |
