[misk-inject](../index.md) / [misk.inject](./index.md)

## Package misk.inject

### Types

| Name | Summary |
|---|---|
| [KAbstractModule](-k-abstract-module/index.md) | `abstract class KAbstractModule : AbstractModule`<br>A class that provides helper methods for working with Kotlin and Guice, allowing implementing classes to operate in the Kotlin type system rather than converting to Java. |

### Extensions for External Classes

| Name | Summary |
|---|---|
| [com.google.inject.binder.ScopedBindingBuilder](com.google.inject.binder.-scoped-binding-builder/index.md) |  |
| [com.google.inject.Injector](com.google.inject.-injector/index.md) |  |
| [com.google.inject.TypeLiteral](com.google.inject.-type-literal/index.md) |  |
| [java.lang.reflect.Type](java.lang.reflect.-type/index.md) |  |
| [kotlin.reflect.KClass](kotlin.reflect.-k-class/index.md) |  |
| [kotlin.reflect.KType](kotlin.reflect.-k-type/index.md) |  |

### Functions

| Name | Summary |
|---|---|
| [keyOf](key-of.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> keyOf(): Key<`[`T`](key-of.md#T)`>`<br>`fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> keyOf(a: `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`): Key<`[`T`](key-of.md#T)`>``fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> keyOf(a: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`>?): Key<`[`T`](key-of.md#T)`>`<br>If annotation is not null, returns a key for @Annotation T, otherwise a key for T. |
| [listOfType](list-of-type.md) | `fun <T> listOfType(elementType: TypeLiteral<`[`T`](list-of-type.md#T)`>): TypeLiteral<`[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`T`](list-of-type.md#T)`>>`<br>`fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> listOfType(elementType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](list-of-type.md#T)`>): TypeLiteral<`[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`T`](list-of-type.md#T)`>>`<br>`fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> listOfType(): TypeLiteral<`[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`T`](list-of-type.md#T)`>>` |
| [mapOfType](map-of-type.md) | `fun <K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, V : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> mapOfType(): TypeLiteral<`[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`K`](map-of-type.md#K)`, `[`V`](map-of-type.md#V)`>>`<br>`fun <K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, V : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> mapOfType(keyType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`K`](map-of-type.md#K)`>, valueType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`V`](map-of-type.md#V)`>): TypeLiteral<`[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`K`](map-of-type.md#K)`, `[`V`](map-of-type.md#V)`>>`<br>`fun <K, V> mapOfType(keyType: TypeLiteral<`[`K`](map-of-type.md#K)`>, valueType: TypeLiteral<`[`V`](map-of-type.md#V)`>): TypeLiteral<`[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`K`](map-of-type.md#K)`, `[`V`](map-of-type.md#V)`>>` |
| [parameterizedType](parameterized-type.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> parameterizedType(vararg typeParameters: `[`Type`](https://docs.oracle.com/javase/8/docs/api/java/lang/reflect/Type.html)`): `[`ParameterizedType`](https://docs.oracle.com/javase/8/docs/api/java/lang/reflect/ParameterizedType.html) |
| [setOfType](set-of-type.md) | `fun <T> setOfType(elementType: TypeLiteral<`[`T`](set-of-type.md#T)`>): TypeLiteral<`[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`T`](set-of-type.md#T)`>>`<br>`fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> setOfType(elementType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](set-of-type.md#T)`>): TypeLiteral<`[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`T`](set-of-type.md#T)`>>`<br>`fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> setOfType(): TypeLiteral<`[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`T`](set-of-type.md#T)`>>` |
| [subtypeOf](subtype-of.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> subtypeOf(): `[`WildcardType`](https://docs.oracle.com/javase/8/docs/api/java/lang/reflect/WildcardType.html) |
| [uninject](uninject.md) | `fun uninject(target: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
