[misk-jobqueue-testing](../../index.md) / [misk.jobqueue](../index.md) / [FakeJobQueue](./index.md)

# FakeJobQueue

`@Singleton class FakeJobQueue : JobQueue`

A fake implementation of [JobQueue](#) intended for testing.

A [FakeJobQueue](./index.md) adds helper methods to inspect the jobs in the queue and to trigger processing.

Example usage might look like this:

```
callApiThatEnqueuesJob()
assertJobIsCorrect(fakeJobQueue.peekJobs(MY_QUEUE).first())

fakeJobQueue.handleJobs()
assertJobSideEffects()
```

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `FakeJobQueue(jobHandlers: Provider<`[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<QueueName, JobHandler>>, tokenGenerator: TokenGenerator)`<br>A fake implementation of [JobQueue](#) intended for testing. |

### Functions

| Name | Summary |
|---|---|
| [enqueue](enqueue.md) | `fun enqueue(queueName: QueueName, body: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, idempotenceKey: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, deliveryDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`?, attributes: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [handleJobs](handle-jobs.md) | `fun handleJobs(queueName: QueueName, assertAcknowledged: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = true): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`FakeJob`](../-fake-job/index.md)`>`<br>`fun handleJobs(assertAcknowledged: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = true): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`FakeJob`](../-fake-job/index.md)`>`<br>Returns all jobs that were handled. |
| [peekJobs](peek-jobs.md) | `fun peekJobs(queueName: QueueName): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<Job>` |
