

### All Types

| Name | Summary |
|---|---|
| [misk.jobqueue.Job](../misk.jobqueue/-job/index.md) | Incoming job |
| [misk.jobqueue.JobConsumer](../misk.jobqueue/-job-consumer/index.md) | A [JobConsumer](../misk.jobqueue/-job-consumer/index.md) allows applications to subscribe to receive incoming jobs |
| [misk.jobqueue.JobHandler](../misk.jobqueue/-job-handler/index.md) | A [JobHandler](../misk.jobqueue/-job-handler/index.md) is an application implemented interface that handles jobs received by this service. [JobHandler](../misk.jobqueue/-job-handler/index.md)s must explicitly call [Job.acknowledge](../misk.jobqueue/-job/acknowledge.md) after successful processing to cause the to be deleted from the underlying queue and not redelivered, or can call [Job.deadLetter](../misk.jobqueue/-job/dead-letter.md) to put the job onto the associated dead letter queue. The jobqueue framework assumes that the underlying queueing system is at-least-once, so handlers must be prepared for the possibility that a job will be delivered more than once (for example if the process fails or the visibility timeout expires after processing but before acknowledgement). Typically this is handled by either storing some sort of ticket in the local database when the job is enqueued and deleting it as part of the application transaction when the job is processed but prior to acknowledgement, or by storing some sort of "processed marker" in the local database during job processing and ignoring jobs whose marker is already recorded. |
| [misk.jobqueue.JobQueue](../misk.jobqueue/-job-queue/index.md) | A [JobQueue](../misk.jobqueue/-job-queue/index.md) enqueues jobs for asynchronous execution, possibly in another process. Jobs are enqueued immediately and may involve an RPC to the underlying job queueing system, so should not be done from within a database transaction. Applications that need to enqueue jobs atomically with a local database transaction should use the [TransactionalJobQueue](#) interface |
| [misk.jobqueue.QueueName](../misk.jobqueue/-queue-name/index.md) |  |
