[misk-jobqueue](../../index.md) / [misk.jobqueue](../index.md) / [JobQueue](index.md) / [enqueue](./enqueue.md)

# enqueue

`open fun enqueue(queueName: `[`QueueName`](../-queue-name/index.md)`, body: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, deliveryDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`? = null, attributes: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`> = mapOf()): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`abstract fun enqueue(queueName: `[`QueueName`](../-queue-name/index.md)`, body: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, idempotenceKey: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = UUID.randomUUID().toString(), deliveryDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`? = null, attributes: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`> = mapOf()): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)

Enqueue a job onto the given queue, along with a set of job attributes.

### Parameters

`queueName` - The name of the queue on which to place the job.

`body` - The body of the job; can be any arbitrary string - it is up to the enqueuer and
consumer to agree on the format of the body.

`idempotenceKey` - Client-assigned unique key, useful for application code to detect duplicate work.
Implementations of both [JobQueue](index.md) and [JobConsumer](../-job-consumer/index.md) are expected to *not* perform any filtering based on this
value, as it carries meaning only for application code (i.e. any logic around this property should take place in
[JobHandler](../-job-handler/index.md)s). Defaults to a randomly generated UUID when not explicitly set.

`deliveryDelay` - If specified, the job will only become visible to the consumer after
the provided duration. Used for jobs that should delay processing for a period of time.

`attributes` - Arbitrary contextual attributes associated with the job. Implementations may limit the number of
attributes per message.