[misk-jobqueue](../../index.md) / [misk.jobqueue](../index.md) / [JobQueue](./index.md)

# JobQueue

`interface JobQueue`

A [JobQueue](./index.md) enqueues jobs for asynchronous execution, possibly in another process. Jobs
are enqueued immediately and may involve an RPC to the underlying job queueing system, so should
not be done from within a database transaction. Applications that need to enqueue jobs
atomically with a local database transaction should use the [TransactionalJobQueue](#) interface

### Functions

| Name | Summary |
|---|---|
| [enqueue](enqueue.md) | `open fun enqueue(queueName: `[`QueueName`](../-queue-name/index.md)`, body: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, deliveryDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`? = null, attributes: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`> = mapOf()): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`abstract fun enqueue(queueName: `[`QueueName`](../-queue-name/index.md)`, body: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, idempotenceKey: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = UUID.randomUUID().toString(), deliveryDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`? = null, attributes: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`> = mapOf()): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Enqueue a job onto the given queue, along with a set of job attributes. |
