[misk-launchdarkly-core](../../index.md) / [misk.feature.launchdarkly](../index.md) / [LaunchDarklyFeatureFlags](./index.md)

# LaunchDarklyFeatureFlags

`@Singleton class LaunchDarklyFeatureFlags : AbstractIdleService, FeatureFlags, FeatureService`

Implementation of [FeatureFlags](#) using LaunchDarkly's Java SDK.
See https://docs.launchdarkly.com/docs/java-sdk-reference documentation.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `LaunchDarklyFeatureFlags(ldClient: LDClientInterface, moshi: Moshi)`<br>Implementation of [FeatureFlags](#) using LaunchDarkly's Java SDK. See https://docs.launchdarkly.com/docs/java-sdk-reference documentation. |

### Functions

| Name | Summary |
|---|---|
| [getBoolean](get-boolean.md) | `fun getBoolean(feature: Feature, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, attributes: Attributes): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [getEnum](get-enum.md) | `fun <T : `[`Enum`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)`<`[`T`](get-enum.md#T)`>> getEnum(feature: Feature, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, clazz: `[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`T`](get-enum.md#T)`>, attributes: Attributes): `[`T`](get-enum.md#T) |
| [getInt](get-int.md) | `fun getInt(feature: Feature, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, attributes: Attributes): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [getJson](get-json.md) | `fun <T> getJson(feature: Feature, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, clazz: `[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`T`](get-json.md#T)`>, attributes: Attributes): `[`T`](get-json.md#T) |
| [getString](get-string.md) | `fun getString(feature: Feature, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, attributes: Attributes): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [shutDown](shut-down.md) | `fun shutDown(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [startUp](start-up.md) | `fun startUp(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
